/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.config.builder;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.config.builder.AbstractBuilder;
import org.pac4j.core.client.Client;
import org.pac4j.oauth.client.DropBoxClient;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.FoursquareClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.YahooClient;

public class OAuthBuilder
extends AbstractBuilder {
    public OAuthBuilder(Map<String, String> properties) {
        super(properties);
    }

    public void tryCreateLinkedInClient(Collection<Client> clients) {
        String id = this.getProperty("linkedin.id");
        String secret = this.getProperty("linkedin.secret");
        String scope = this.getProperty("linkedin.scope");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            LinkedIn2Client linkedInClient = new LinkedIn2Client(id, secret);
            if (StringUtils.isNotBlank((CharSequence)scope)) {
                linkedInClient.setScope(scope);
            }
            clients.add((Client)linkedInClient);
        }
    }

    public void tryCreateFacebookClient(Collection<Client> clients) {
        String id = this.getProperty("facebook.id");
        String secret = this.getProperty("facebook.secret");
        String scope = this.getProperty("facebook.scope");
        String fields = this.getProperty("facebook.fields");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            FacebookClient facebookClient = new FacebookClient(id, secret);
            if (StringUtils.isNotBlank((CharSequence)scope)) {
                facebookClient.setScope(scope);
            }
            if (StringUtils.isNotBlank((CharSequence)fields)) {
                facebookClient.setFields(fields);
            }
            clients.add((Client)facebookClient);
        }
    }

    public void tryCreateWindowsLiveClient(Collection<Client> clients) {
        String id = this.getProperty("windowslive.id");
        String secret = this.getProperty("windowslive.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            WindowsLiveClient client = new WindowsLiveClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateFoursquareClient(Collection<Client> clients) {
        String id = this.getProperty("foursquare.id");
        String secret = this.getProperty("foursquare.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            FoursquareClient client = new FoursquareClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateGoogleClient(Collection<Client> clients) {
        String id = this.getProperty("google.id");
        String secret = this.getProperty("google.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            Google2Client client = new Google2Client(id, secret);
            String scope = this.getProperty("google.scope");
            if (StringUtils.isNotBlank((CharSequence)scope)) {
                client.setScope(Google2Client.Google2Scope.valueOf((String)scope.toUpperCase()));
            }
            clients.add((Client)client);
        }
    }

    public void tryCreateYahooClient(Collection<Client> clients) {
        String id = this.getProperty("yahoo.id");
        String secret = this.getProperty("yahoo.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            YahooClient client = new YahooClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateDropboxClient(Collection<Client> clients) {
        String id = this.getProperty("dropbox.id");
        String secret = this.getProperty("dropbox.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            DropBoxClient client = new DropBoxClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateGithubClient(Collection<Client> clients) {
        String id = this.getProperty("github.id");
        String secret = this.getProperty("github.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            GitHubClient client = new GitHubClient(id, secret);
            clients.add((Client)client);
        }
    }

    public void tryCreateTwitterClient(Collection<Client> clients) {
        String id = this.getProperty("twitter.id");
        String secret = this.getProperty("twitter.secret");
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)secret)) {
            TwitterClient twitterClient = new TwitterClient(id, secret);
            clients.add((Client)twitterClient);
        }
    }

    public void tryCreateGenericOAuth2Clients(Collection<Client> clients) {
        for (int i = 0; i <= 100; ++i) {
            String id = this.getProperty("oauth2.id", i);
            String secret = this.getProperty("oauth2.secret", i);
            if (!StringUtils.isNotBlank((CharSequence)id) || !StringUtils.isNotBlank((CharSequence)secret)) continue;
            GenericOAuth20Client client = new GenericOAuth20Client();
            client.setName(this.concat(client.getName(), i));
            client.setKey(id);
            client.setSecret(secret);
            client.setAuthUrl(this.getProperty("oauth2.authUrl", i));
            client.setTokenUrl(this.getProperty("oauth2.tokenUrl", i));
            client.setProfileUrl(this.getProperty("oauth2.profileUrl", i));
            client.setProfilePath(this.getProperty("oauth2.profilePath", i));
            client.setProfileId(this.getProperty("oauth2.profileId", i));
            client.setScope(this.getProperty("oauth2.scope", i));
            if (this.containsProperty("oauth2.withState", i)) {
                client.setWithState(this.getPropertyAsBoolean("oauth2.withState", i));
            }
            if (this.containsProperty("oauth2.clientAuthenticationMethod", i)) {
                client.setClientAuthenticationMethod(this.getProperty("oauth2.clientAuthenticationMethod", i));
            }
            clients.add((Client)client);
        }
    }
}

