/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support;

import org.springframework.integration.support.BaseMessageBuilder;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public final class MessageBuilder<T>
extends BaseMessageBuilder<T, MessageBuilder<T>> {
    private MessageBuilder(T payload, @Nullable Message<T> originalMessage) {
        super(payload, originalMessage);
    }

    public static <T> MessageBuilder<T> fromMessage(Message<T> message) {
        Assert.notNull(message, (String)"message must not be null");
        return new MessageBuilder<Object>(message.getPayload(), message);
    }

    public static <T> MessageBuilder<T> withPayload(T payload) {
        return new MessageBuilder<T>(payload, null);
    }
}

