/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.atlas;

import com.netflix.spectator.api.Timer;
import com.netflix.spectator.atlas.AtlasTimer;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class AtlasTimerBatchUpdater
implements Timer.BatchUpdater,
Consumer<Supplier<Timer>> {
    private Supplier<Timer> timerSupplier;
    private final int batchSize;
    private int count;
    private double total;
    private double totalOfSquares;
    private long max;

    AtlasTimerBatchUpdater(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void accept(Supplier<Timer> timerSupplier) {
        this.timerSupplier = timerSupplier;
    }

    private AtlasTimer getTimer() {
        if (this.timerSupplier != null) {
            Timer t = this.timerSupplier.get();
            return t instanceof AtlasTimer ? (AtlasTimer)t : null;
        }
        return null;
    }

    public void record(long amount, TimeUnit unit) {
        ++this.count;
        if (amount > 0L) {
            long nanos = unit.toNanos(amount);
            this.total += (double)nanos;
            this.totalOfSquares += (double)nanos * (double)nanos;
            if (nanos > this.max) {
                this.max = nanos;
            }
        }
        if (this.count >= this.batchSize) {
            this.flush();
        }
    }

    public void flush() {
        AtlasTimer timer = this.getTimer();
        if (timer != null) {
            timer.update(this.count, this.total, this.totalOfSquares, this.max);
            this.count = 0;
            this.total = 0.0;
            this.totalOfSquares = 0.0;
            this.max = 0L;
        }
    }

    public void close() throws Exception {
        this.flush();
    }
}

