/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.aztec.decoder.Decoder;
import com.google.zxing.aztec.detector.Detector;
import com.google.zxing.common.DecoderResult;
import java.util.List;
import java.util.Map;

public final class AztecReader
implements Reader {
    @Override
    public Result decode(BinaryBitmap image) throws NotFoundException, FormatException {
        return this.decode(image, null);
    }

    @Override
    public Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        String ecLevel;
        ResultPointCallback rpcb;
        AztecDetectorResult detectorResult;
        NotFoundException notFoundException = null;
        FormatException formatException = null;
        Detector detector = new Detector(image.getBlackMatrix());
        ResultPoint[] points = null;
        DecoderResult decoderResult = null;
        int errorsCorrected = 0;
        try {
            detectorResult = detector.detect(false);
            points = detectorResult.getPoints();
            errorsCorrected = detectorResult.getErrorsCorrected();
            decoderResult = new Decoder().decode(detectorResult);
        }
        catch (NotFoundException e) {
            notFoundException = e;
        }
        catch (FormatException e) {
            formatException = e;
        }
        if (decoderResult == null) {
            try {
                detectorResult = detector.detect(true);
                points = detectorResult.getPoints();
                errorsCorrected = detectorResult.getErrorsCorrected();
                decoderResult = new Decoder().decode(detectorResult);
            }
            catch (FormatException | NotFoundException e) {
                if (notFoundException != null) {
                    throw notFoundException;
                }
                if (formatException != null) {
                    throw formatException;
                }
                throw e;
            }
        }
        if (hints != null && (rpcb = (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) != null) {
            for (ResultPoint point : points) {
                rpcb.foundPossibleResultPoint(point);
            }
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), decoderResult.getNumBits(), points, BarcodeFormat.AZTEC, System.currentTimeMillis());
        List<byte[]> byteSegments = decoderResult.getByteSegments();
        if (byteSegments != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, byteSegments);
        }
        if ((ecLevel = decoderResult.getECLevel()) != null) {
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ecLevel);
        }
        result.putMetadata(ResultMetadataType.ERRORS_CORRECTED, errorsCorrected += decoderResult.getErrorsCorrected().intValue());
        result.putMetadata(ResultMetadataType.SYMBOLOGY_IDENTIFIER, "]z" + decoderResult.getSymbologyModifier());
        return result;
    }

    @Override
    public void reset() {
    }
}

