/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.keymaster.rest.cxf.service;

import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import org.apache.syncope.common.keymaster.client.api.model.Domain;
import org.apache.syncope.common.keymaster.rest.api.service.DomainService;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.core.logic.DomainLogic;

public class DomainServiceImpl
implements DomainService {
    private static final long serialVersionUID = -375255764389240615L;
    @Context
    protected UriInfo uriInfo;
    protected final DomainLogic logic;

    public DomainServiceImpl(DomainLogic logic) {
        this.logic = logic;
    }

    public List<Domain> list() {
        return this.logic.list();
    }

    public Domain read(String key) {
        return this.logic.read(key);
    }

    public Response create(Domain domain) {
        Domain created = this.logic.create(domain);
        URI location = this.uriInfo.getAbsolutePathBuilder().path(created.getKey()).build(new Object[0]);
        return Response.created((URI)location).header("X-Syncope-Key", (Object)created.getKey()).build();
    }

    public void deployed(String key) {
        this.logic.deployed(key);
    }

    public void changeAdminPassword(String key, String password, CipherAlgorithm cipherAlgorithm) {
        this.logic.changeAdminPassword(key, password, cipherAlgorithm);
    }

    public void adjustPoolSize(String key, int poolMaxActive, int poolMinIdle) {
        this.logic.adjustPoolSize(key, poolMaxActive, poolMinIdle);
    }

    public void delete(String key) {
        this.logic.delete(key);
    }
}

