/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.debug;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.debug.DebugSettingsProperties;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.DebugSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.core.settings.debug", value={"enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={DebugSettingsProperties.class})
public class DebugSettingsConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private DebugSettingsProperties properties;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        if (this.properties.isEnabled()) {
            DebugSettings debugSettings = webApplication.getDebugSettings();
            debugSettings.setDevelopmentUtilitiesEnabled(this.properties.isDevelopmentUtilitiesEnabled());
            debugSettings.setAjaxDebugModeEnabled(this.properties.isAjaxDebugModeEnabled());
            debugSettings.setComponentUseCheck(this.properties.isComponentUseCheck());
            debugSettings.setLinePreciseReportingOnAddComponentEnabled(this.properties.isLinePreciseReportingOnAddComponentEnabled());
            debugSettings.setLinePreciseReportingOnNewComponentEnabled(this.properties.isLinePreciseReportingOnNewComponentEnabled());
            debugSettings.setOutputMarkupContainerClassName(this.properties.isOutputMarkupContainerClassName());
            debugSettings.setComponentPathAttributeName(this.properties.getComponentPathAttributeName());
        }
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.properties).build());
    }
}

