/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.persistence.criteria.ComparisonStyle;
import org.apache.openjpa.persistence.criteria.PredicateImpl;

class CompareByExample<T>
extends PredicateImpl {
    CompareByExample(CriteriaBuilder builder, ManagedType<T> type, Path<T> from, T instance, ComparisonStyle style, Attribute<?, ?> ... excludes) {
        super(CompareByExample.extractOperator(style));
        List<Object> excludeAttr = excludes == null ? new ArrayList() : Arrays.asList(excludes);
        Set attrs = type.getSingularAttributes();
        for (SingularAttribute attr : attrs) {
            if (excludeAttr.contains(attr) || style.excludeIdentity() && attr.isId() || style.excludeVersion() && attr.isVersion()) continue;
            Object value = this.extractValue(instance, attr);
            if (style.excludeNull() && value == null || style.excludeDefault() && this.isDefaultValue(attr.getJavaType(), value)) continue;
            Predicate p = null;
            if (value == null) {
                p = from.get(attr).isNull();
                this.add((Expression<Boolean>)p);
                continue;
            }
            if (attr.isAssociation()) {
                p = new CompareByExample(builder, (ManagedType)attr.getType(), from.get(attr), value, style, excludes);
            } else if (attr.getJavaType() == String.class) {
                Expression s = from.get(attr).as(String.class);
                switch (style.getStringComparsionMode()) {
                    case EXACT: {
                        p = builder.equal(s, value);
                        break;
                    }
                    case CASE_INSENSITIVE: {
                        p = builder.equal(builder.upper(s), (Object)value.toString());
                        break;
                    }
                    case LIKE: {
                        p = builder.like(s, value.toString());
                    }
                }
            } else {
                p = builder.equal((Expression)from.get(attr), value);
            }
            this.add((Expression<Boolean>)p);
        }
    }

    Object extractValue(T instance, SingularAttribute<? super T, ?> attr) {
        Class<?> cls = instance.getClass();
        Method getter = Reflection.findGetter(cls, (String)attr.getName(), (boolean)false);
        if (getter != null) {
            return Reflection.get(instance, (Method)getter);
        }
        Field field = Reflection.findField(cls, (String)attr.getName(), (boolean)false);
        if (field != null) {
            return Reflection.get(instance, (Field)field);
        }
        return null;
    }

    boolean isDefaultValue(Class<?> cls, Object val) {
        if (val == null) {
            return true;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.FALSE.equals(val);
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return ((Character)val).charValue() == '\u0000';
        }
        if (cls == Byte.class || cls == Byte.TYPE || cls == Double.class || cls == Double.TYPE || cls == Float.class || cls == Float.TYPE || cls == Long.class || cls == Long.TYPE || cls == Integer.class || cls == Integer.TYPE || cls == Short.class || cls == Short.TYPE) {
            return ((Number)val).intValue() == 0;
        }
        if (cls == String.class) {
            return "".equals(val);
        }
        return false;
    }

    static <T> Predicate.BooleanOperator extractOperator(ComparisonStyle style) {
        return style == null ? Predicate.BooleanOperator.AND : (style.isDisjunction() ? Predicate.BooleanOperator.OR : Predicate.BooleanOperator.AND);
    }
}

