/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring5.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring5.context.IThymeleafBindStatus;
import org.thymeleaf.spring5.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring5.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.spring5.util.SpringValueFormatter;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.util.StringUtils;

public final class SpringTextareaFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public SpringTextareaFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "textarea", null, null, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IThymeleafBindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, false);
        String value = SpringValueFormatter.getDisplayString(bindStatus.getValue(), bindStatus.getEditor(), true);
        String processedValue = RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, "textarea");
        if (!StringUtils.isEmpty((String)processedValue)) {
            char c0 = processedValue.charAt(0);
            if (c0 == '\n') {
                processedValue = '\n' + processedValue;
            } else if (c0 == '\r' && processedValue.length() > 1 && processedValue.charAt(1) == '\n') {
                processedValue = "\r\n" + processedValue;
            } else if (c0 == '\r') {
                processedValue = '\r' + processedValue;
            }
        }
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.idAttributeDefinition, (String)"id", (String)id);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)name);
        structureHandler.setBody((CharSequence)(processedValue == null ? "" : processedValue), false);
    }
}

