/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent.subprocess;

import com.microsoft.alm.oauth2.useragent.subprocess.StreamConsumer;
import com.microsoft.alm.oauth2.useragent.subprocess.TestableProcess;
import java.io.PrintStream;

public class ProcessCoordinator {
    private final TestableProcess process;
    private final PrintStream stdIn;
    private final StreamConsumer stdOut;
    private final Thread stdOutThread;
    private final StreamConsumer stdErr;
    private final Thread stdErrThread;

    public ProcessCoordinator(TestableProcess process) {
        this.process = process;
        this.stdIn = new PrintStream(process.getOutputStream());
        this.stdOut = new StreamConsumer(process.getInputStream());
        this.stdOutThread = new Thread(this.stdOut);
        this.stdOutThread.start();
        this.stdErr = new StreamConsumer(process.getErrorStream());
        this.stdErrThread = new Thread(this.stdErr);
        this.stdErrThread.start();
    }

    public void print(String s) {
        this.stdIn.print(s);
    }

    public void println(String s) {
        this.stdIn.println(s);
    }

    public int waitFor() throws InterruptedException {
        this.stdIn.flush();
        this.stdIn.close();
        this.stdOutThread.join();
        this.stdErrThread.join();
        return this.process.waitFor();
    }

    public String getStdOut() {
        return this.stdOut.toString();
    }

    public String getStdErr() {
        return this.stdErr.toString();
    }
}

