/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.pageStore.SerializedPage;
import org.apache.wicket.serialize.ISerializer;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Classes;

public class SerializingPageStore
extends DelegatingPageStore {
    private final ISerializer serializer;

    public SerializingPageStore(IPageStore delegate, ISerializer serializer) {
        super(delegate);
        this.serializer = (ISerializer)Args.notNull((Object)serializer, (String)"serializer");
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    @Override
    public boolean canBeAsynchronous(IPageContext context) {
        return this.getDelegate().canBeAsynchronous(context);
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        IManageablePage page = this.getDelegate().getPage(context, id);
        if (page instanceof SerializedPage) {
            page = (IManageablePage)this.serializer.deserialize(((SerializedPage)page).getData());
        }
        return page;
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        if (!(page instanceof SerializedPage)) {
            page = new SerializedPage(page.getPageId(), Classes.name(page.getClass()), this.serializer.serialize(page));
        }
        this.getDelegate().addPage(context, page);
    }
}

