/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.api.FormDefinitionQuery;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormRepositoryService;

public class GetFormDefinitionsForProcessDefinitionCmd
implements Command<List<FormDefinition>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected FormRepositoryService formRepositoryService;

    public GetFormDefinitionsForProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<FormDefinition> execute(CommandContext commandContext) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition for id: " + this.processDefinitionId, ProcessDefinition.class);
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId);
        if (bpmnModel == null) {
            throw new FlowableObjectNotFoundException("Cannot find bpmn model for process definition id: " + this.processDefinitionId, BpmnModel.class);
        }
        if (CommandContextUtil.getFormRepositoryService() == null) {
            throw new FlowableException("Form repository service is not available");
        }
        this.formRepositoryService = CommandContextUtil.getFormRepositoryService();
        List<FormDefinition> formDefinitions = this.getFormDefinitionsFromModel(bpmnModel, processDefinition);
        return formDefinitions;
    }

    protected List<FormDefinition> getFormDefinitionsFromModel(BpmnModel bpmnModel, ProcessDefinition processDefinition) {
        HashSet<String> formKeys = new HashSet<String>();
        ArrayList<FormDefinition> formDefinitions = new ArrayList<FormDefinition>();
        List startEvents = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class, true);
        for (StartEvent startEvent : startEvents) {
            if (!StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) continue;
            formKeys.add(startEvent.getFormKey());
        }
        List userTasks = bpmnModel.getMainProcess().findFlowElementsOfType(UserTask.class, true);
        for (UserTask userTask : userTasks) {
            if (!StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) continue;
            formKeys.add(userTask.getFormKey());
        }
        for (String formKey : formKeys) {
            this.addFormDefinitionToCollection(formDefinitions, formKey, processDefinition);
        }
        return formDefinitions;
    }

    protected void addFormDefinitionToCollection(List<FormDefinition> formDefinitions, String formKey, ProcessDefinition processDefinition) {
        FormDefinitionQuery formDefinitionQuery = this.formRepositoryService.createFormDefinitionQuery().formDefinitionKey(formKey);
        Deployment deployment = (Deployment)CommandContextUtil.getDeploymentEntityManager().findById(processDefinition.getDeploymentId());
        if (deployment.getParentDeploymentId() != null) {
            List formDeployments = this.formRepositoryService.createDeploymentQuery().parentDeploymentId(deployment.getParentDeploymentId()).list();
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionQuery.deploymentId(((FormDeployment)formDeployments.get(0)).getId());
            } else {
                formDefinitionQuery.latestVersion();
            }
        } else {
            formDefinitionQuery.latestVersion();
        }
        FormDefinition formDefinition = (FormDefinition)formDefinitionQuery.singleResult();
        if (formDefinition != null) {
            formDefinitions.add(formDefinition);
        }
    }
}

