/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.struts2.interceptor;

import org.apache.struts2.ActionContext;
import org.apache.struts2.mock.MockActionInvocation;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsInternalTestCase;
import org.jmock.Mock;
import org.jmock.core.constraint.IsEqual;
import org.jmock.core.matcher.InvokeOnceMatcher;

import jakarta.servlet.http.HttpServletRequest;

/**
 * Test case for CreateSessionInterceptor.
 *
 */
public class CreateSessionInterceptorTest extends StrutsInternalTestCase {

    private MockActionInvocation invocation;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        invocation = new MockActionInvocation();
        invocation.setInvocationContext(ActionContext.getContext());
    }

    public void testCreateSession() throws Exception {
        Mock httpServletRequestMock = new Mock(HttpServletRequest.class);
        httpServletRequestMock.expects(new InvokeOnceMatcher()).method("getSession").with(new IsEqual(Boolean.FALSE));
        httpServletRequestMock.expects(new InvokeOnceMatcher()).method("getSession").with(new IsEqual(Boolean.TRUE));
        httpServletRequestMock.expects(new InvokeOnceMatcher()).method("getSession").with(new IsEqual(Boolean.FALSE));
        HttpServletRequest request = (HttpServletRequest) httpServletRequestMock.proxy();

        ServletActionContext.setRequest(request);

        CreateSessionInterceptor interceptor = new CreateSessionInterceptor();

        interceptor.intercept(invocation);

        httpServletRequestMock.verify();
    }
}
