/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.ExifUtil;
import net.sf.jasperreports.engine.util.JRTypeSniffer;

public final class ImageUtil {
    private static final boolean checkExif;

    public static float getXAlignFactor(JRImageAlignment imageAlignment) {
        return ImageUtil.getXAlignFactor(imageAlignment.getHorizontalImageAlign());
    }

    public static float getXAlignFactor(HorizontalImageAlignEnum horizontalAlign) {
        float xalignFactor = 0.0f;
        switch (horizontalAlign) {
            case RIGHT: {
                xalignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xalignFactor = 0.5f;
                break;
            }
            default: {
                xalignFactor = 0.0f;
            }
        }
        return xalignFactor;
    }

    public static float getYAlignFactor(JRImageAlignment imageAlignment) {
        return ImageUtil.getYAlignFactor(imageAlignment.getVerticalImageAlign());
    }

    public static float getYAlignFactor(VerticalImageAlignEnum verticalAlign) {
        float yalignFactor = 0.0f;
        switch (verticalAlign) {
            case BOTTOM: {
                yalignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yalignFactor = 0.5f;
                break;
            }
            default: {
                yalignFactor = 0.0f;
            }
        }
        return yalignFactor;
    }

    public static ExifOrientationEnum getExifOrientation(byte[] data) {
        ExifOrientationEnum exifOrientation = null;
        if (checkExif && JRTypeSniffer.isJPEG(data)) {
            exifOrientation = ExifUtil.getExifOrientation(data);
        }
        return exifOrientation == null ? ExifOrientationEnum.NORMAL : exifOrientation;
    }

    public static RotationEnum getRotation(RotationEnum rotation, ExifOrientationEnum exifOrientation) {
        RotationEnum result = rotation;
        switch (exifOrientation) {
            case UPSIDE_DOWN: {
                switch (rotation) {
                    case NONE: {
                        result = RotationEnum.UPSIDE_DOWN;
                        break;
                    }
                    case LEFT: {
                        result = RotationEnum.RIGHT;
                        break;
                    }
                    case RIGHT: {
                        result = RotationEnum.LEFT;
                        break;
                    }
                    case UPSIDE_DOWN: {
                        result = RotationEnum.NONE;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (rotation) {
                    case NONE: {
                        result = RotationEnum.RIGHT;
                        break;
                    }
                    case LEFT: {
                        result = RotationEnum.NONE;
                        break;
                    }
                    case RIGHT: {
                        result = RotationEnum.UPSIDE_DOWN;
                        break;
                    }
                    case UPSIDE_DOWN: {
                        result = RotationEnum.LEFT;
                    }
                }
                break;
            }
            case LEFT: {
                switch (rotation) {
                    case NONE: {
                        result = RotationEnum.LEFT;
                        break;
                    }
                    case LEFT: {
                        result = RotationEnum.UPSIDE_DOWN;
                        break;
                    }
                    case RIGHT: {
                        result = RotationEnum.NONE;
                        break;
                    }
                    case UPSIDE_DOWN: {
                        result = RotationEnum.RIGHT;
                    }
                }
                break;
            }
        }
        return result;
    }

    public static Insets getExifCrop(JRPrintImage image, ExifOrientationEnum exifOrientation, double cropTop, double cropLeft, double cropBottom, double cropRight) {
        block0 : switch (image.getRotation()) {
            case LEFT: {
                switch (exifOrientation) {
                    case UPSIDE_DOWN: {
                        double t = cropLeft;
                        cropLeft = cropRight;
                        cropRight = t;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                    case RIGHT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                    case LEFT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                }
                break;
            }
            case RIGHT: {
                switch (exifOrientation) {
                    case UPSIDE_DOWN: {
                        double t = cropLeft;
                        cropLeft = cropRight;
                        cropRight = t;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                    case RIGHT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                    case LEFT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                }
                break;
            }
            case UPSIDE_DOWN: {
                switch (exifOrientation) {
                    case UPSIDE_DOWN: {
                        double t = cropLeft;
                        cropLeft = cropRight;
                        cropRight = t;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                    case RIGHT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                    case LEFT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break;
                    }
                }
                break;
            }
            default: {
                switch (exifOrientation) {
                    case UPSIDE_DOWN: {
                        double t = cropLeft;
                        cropLeft = cropRight;
                        cropRight = t;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break block0;
                    }
                    case RIGHT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                            t = cropLeft;
                            cropLeft = cropRight;
                            cropRight = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block0;
                        t = cropTop;
                        cropTop = cropBottom;
                        cropBottom = t;
                        break block0;
                    }
                    case LEFT: {
                        double t;
                        if (image.getHorizontalImageAlign() == HorizontalImageAlignEnum.LEFT && image.getVerticalImageAlign() == VerticalImageAlignEnum.BOTTOM || image.getHorizontalImageAlign() == HorizontalImageAlignEnum.RIGHT && image.getVerticalImageAlign() == VerticalImageAlignEnum.TOP) {
                            t = cropTop;
                            cropTop = cropBottom;
                            cropBottom = t;
                        }
                        if ((image.getHorizontalImageAlign() != HorizontalImageAlignEnum.LEFT || image.getVerticalImageAlign() != VerticalImageAlignEnum.TOP) && (image.getHorizontalImageAlign() != HorizontalImageAlignEnum.RIGHT || image.getVerticalImageAlign() != VerticalImageAlignEnum.BOTTOM)) break block0;
                        t = cropLeft;
                        cropLeft = cropRight;
                        cropRight = t;
                        break block0;
                    }
                }
            }
        }
        return new Insets(cropTop, cropLeft, cropBottom, cropRight);
    }

    static {
        boolean drewFound = false;
        try {
            ImageUtil.class.getClassLoader().loadClass("com.drew.metadata.Metadata");
            drewFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        checkExif = drewFound;
    }

    public static class Insets {
        public final double top;
        public final double left;
        public final double bottom;
        public final double right;

        public Insets(double top, double left, double bottom, double right) {
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }
    }
}

