/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.type.ImageTypeEnum;

public final class JRTypeSniffer {
    public static boolean isGIF(byte[] data) {
        if (data.length < 3) {
            return false;
        }
        return data[0] == 71 && data[1] == 73 && data[2] == 70;
    }

    public static boolean isJPEG(byte[] data) {
        if (data.length < 2) {
            return false;
        }
        return data[0] == -1 && data[1] == -40;
    }

    public static boolean isPNG(byte[] data) {
        if (data.length < 8) {
            return false;
        }
        return data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71 && data[4] == 13 && data[5] == 10 && data[6] == 26 && data[7] == 10;
    }

    public static boolean isTIFF(byte[] data) {
        if (data.length < 2) {
            return false;
        }
        return data[0] == 73 && data[1] == 73 || data[0] == 77 && data[1] == 77;
    }

    public static boolean isWEBP(byte[] data) {
        if (data.length < 15) {
            return false;
        }
        return data[0] == 82 && data[1] == 73 && data[2] == 70 && data[3] == 70 && data[8] == 87 && data[9] == 69 && data[10] == 66 && data[11] == 80 && data[12] == 86 && data[13] == 80 && data[14] == 56;
    }

    public static ImageTypeEnum getImageTypeValue(byte[] data) {
        if (JRTypeSniffer.isGIF(data)) {
            return ImageTypeEnum.GIF;
        }
        if (JRTypeSniffer.isJPEG(data)) {
            return ImageTypeEnum.JPEG;
        }
        if (JRTypeSniffer.isPNG(data)) {
            return ImageTypeEnum.PNG;
        }
        if (JRTypeSniffer.isTIFF(data)) {
            return ImageTypeEnum.TIFF;
        }
        if (JRTypeSniffer.isWEBP(data)) {
            return ImageTypeEnum.WEBP;
        }
        return ImageTypeEnum.UNKNOWN;
    }

    private JRTypeSniffer() {
    }
}

