/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.json;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.json.JSONException;
import org.apache.struts2.json.JSONUtil;
import org.apache.struts2.util.TextParseUtil;
import org.apache.struts2.util.WildcardUtil;

public abstract class JSONCleaner {
    private static final Logger LOG = LogManager.getLogger(JSONCleaner.class);
    private boolean defaultBlock = false;
    private Collection<String> allowed;
    private Collection<String> blocked;
    private Map<String, Filter> includesExcludesMap;

    public Object clean(String ognlPrefix, Object data) throws JSONException {
        if (data == null) {
            return null;
        }
        if (data instanceof List) {
            return this.cleanList(ognlPrefix, data);
        }
        if (data instanceof Map) {
            return this.cleanMap(ognlPrefix, data);
        }
        return this.cleanValue(ognlPrefix, data);
    }

    protected Object cleanList(String ognlPrefix, Object data) throws JSONException {
        List list = (List)data;
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            list.set(i, this.clean(ognlPrefix + "[" + i + "]", list.get(i)));
        }
        return list;
    }

    protected Object cleanMap(String ognlPrefix, Object data) throws JSONException {
        Map map = (Map)data;
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            String key = (String)(ognlPrefix.length() > 0 ? ognlPrefix + "." : "") + String.valueOf(e.getKey());
            if (this.allow(key)) {
                e.setValue(this.clean(key, e.getValue()));
                continue;
            }
            LOG.debug("Blocked: {}", (Object)key);
            iter.remove();
        }
        return map;
    }

    protected abstract Object cleanValue(String var1, Object var2) throws JSONException;

    private boolean allow(String ognl) {
        boolean allow;
        Map<String, Filter> includesExcludesMap = this.getIncludesExcludesMap();
        boolean bl = allow = !this.isDefaultBlock();
        if (includesExcludesMap != null) {
            for (Filter f : includesExcludesMap.values()) {
                if (!f.pattern.matcher(ognl).matches()) continue;
                allow = f.allow;
            }
        }
        return allow;
    }

    public Map<String, Filter> getIncludesExcludesMap() {
        if (this.allowed == null && this.blocked == null) {
            return this.includesExcludesMap;
        }
        if (this.includesExcludesMap == null) {
            this.includesExcludesMap = new TreeMap<String, Filter>();
            HashMap<Object, Boolean> existingExpr = new HashMap<Object, Boolean>();
            Map<String, Map<String, String>> includePatternData = JSONUtil.getIncludePatternData();
            String splitPattern = includePatternData.get("split").get("wildcard");
            String joinString = includePatternData.get("join").get("wildcard");
            String arrayBegin = includePatternData.get("array-begin").get("wildcard");
            String arrayEnd = includePatternData.get("array-end").get("wildcard");
            if (this.allowed != null) {
                for (String a : this.allowed) {
                    Object expr = "";
                    for (String piece : a.split(splitPattern)) {
                        if (((String)expr).length() > 0) {
                            expr = (String)expr + joinString;
                        }
                        if (existingExpr.containsKey(expr = (String)expr + piece)) continue;
                        existingExpr.put(expr, Boolean.TRUE);
                        Object s = expr;
                        if (piece.endsWith(arrayEnd)) {
                            s = ((String)expr).substring(0, ((String)expr).lastIndexOf(arrayBegin));
                        }
                        if (((String)s).length() <= 0) continue;
                        this.includesExcludesMap.put((String)s, new Filter((String)s, true));
                        LOG.debug("Adding include wildcard expression: {}", s);
                    }
                }
            }
            if (this.blocked != null) {
                for (String b : this.blocked) {
                    this.includesExcludesMap.put(b, new Filter(b, false));
                }
            }
        }
        return this.includesExcludesMap;
    }

    public void setIncludesExcludesMap(Map<String, Filter> map) {
        this.includesExcludesMap = map;
    }

    public boolean isDefaultBlock() {
        return this.defaultBlock;
    }

    public void setDefaultBlock(boolean defaultExclude) {
        this.defaultBlock = defaultExclude;
    }

    public Collection<String> getBlockedCollection() {
        return this.blocked;
    }

    public void setBlockedCollection(Collection<String> blocked) {
        this.blocked = blocked;
    }

    public void setBlocked(String blocked) {
        this.setBlockedCollection(this.asCollection(blocked));
    }

    public Collection<String> getAllowedCollection() {
        return this.allowed;
    }

    public void setAllowedCollection(Collection<String> allowed) {
        this.allowed = allowed;
    }

    public void setAllowed(String allowed) {
        this.setAllowedCollection(this.asCollection(allowed));
    }

    private Collection<String> asCollection(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        return TextParseUtil.commaDelimitedStringToSet((String)commaDelim);
    }

    public static class Filter {
        public Pattern pattern;
        public boolean allow;

        public Filter(String pattern, boolean allow) {
            this.pattern = WildcardUtil.compileWildcardPattern((String)pattern);
            this.allow = allow;
        }
    }
}

