/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.paxexam.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.sling.maven.projectsupport.BundleListUtils;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.Bundle;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.BundleList;
import org.apache.sling.maven.projectsupport.bundlelist.v1_0_0.StartLevel;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.options.CompositeOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingPaxOptions {
    private static final Logger log = LoggerFactory.getLogger(SlingPaxOptions.class);
    public static final int DEFAULT_SLING_START_LEVEL = 30;
    public static final String PROP_TELNET_PORT = "osgi.shell.telnet.port";
    public static final String PROP_HTTP_PORT = "org.osgi.service.http.port";
    public static final String DEFAULT_RUN_MODES = "jackrabbit";
    private static String[] ignoredBundlePrefixes;

    private static int getAvailablePort() {
        int result = Integer.MIN_VALUE;
        try {
            ServerSocket s = new ServerSocket(0);
            result = s.getLocalPort();
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void setIgnoredBundles(String ... symbolicNamePrefix) {
        ignoredBundlePrefixes = symbolicNamePrefix == null || symbolicNamePrefix.length == 0 ? new String[0] : symbolicNamePrefix;
    }

    public static Collection<String> getTestRunModes() {
        String runModes = System.getProperty("sling.run.modes", DEFAULT_RUN_MODES);
        return Arrays.asList(runModes.split(","));
    }

    public static CompositeOption defaultLaunchpadOptions(String launchpadVersion) {
        String paxLogLevel = System.getProperty("pax.exam.log.level", "INFO");
        int slingStartLevel = 30;
        String telnetPort = System.getProperty(PROP_TELNET_PORT, String.valueOf(SlingPaxOptions.getAvailablePort()));
        String httpPort = System.getProperty(PROP_HTTP_PORT, String.valueOf(SlingPaxOptions.getAvailablePort()));
        log.info("{}={}", (Object)PROP_TELNET_PORT, (Object)telnetPort);
        log.info("{}={}", (Object)PROP_HTTP_PORT, (Object)httpPort);
        return new DefaultCompositeOption(new Option[]{CoreOptions.junitBundles(), CoreOptions.systemProperty((String)"org.ops4j.pax.logging.DefaultServiceLog.level").value(paxLogLevel), SlingPaxOptions.felixRemoteShellBundles(), SlingPaxOptions.slingBootstrapBundles(), SlingPaxOptions.slingLaunchpadBundles(launchpadVersion), CoreOptions.frameworkStartLevel((int)30), CoreOptions.frameworkProperty((String)PROP_TELNET_PORT).value((Object)telnetPort), CoreOptions.frameworkProperty((String)PROP_HTTP_PORT).value((Object)httpPort)});
    }

    private static boolean ignore(Bundle b) {
        boolean result = false;
        if (ignoredBundlePrefixes != null) {
            String sn = b.getArtifactId();
            for (String prefix : ignoredBundlePrefixes) {
                if (!sn.startsWith(prefix)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static CompositeOption slingBundleList(String groupId, String artifactId, String version, String type, String classifier) {
        DefaultCompositeOption result = new DefaultCompositeOption();
        String paxUrl = "mvn:" + groupId + "/" + artifactId + "/" + (version == null ? "" : version) + "/" + (type == null ? "" : type) + "/" + (classifier == null ? "" : classifier);
        log.info("Getting bundle list {}", (Object)paxUrl);
        File tmp = null;
        Collection<String> testRunModes = SlingPaxOptions.getTestRunModes();
        try {
            tmp = SlingPaxOptions.dumpMvnUrlToTmpFile(paxUrl);
            BundleList list = BundleListUtils.readBundleList((File)tmp);
            int counter = 0;
            int ignored = 0;
            for (StartLevel s : list.getStartLevels()) {
                int startLevel = s.getStartLevel() < 0 ? 1 : s.getStartLevel();
                for (Bundle b : s.getBundles()) {
                    if (SlingPaxOptions.ignore(b)) {
                        log.info("Bundle ignored due to setIgnoredBundles: {}", (Object)b);
                        ++ignored;
                        continue;
                    }
                    ++counter;
                    ArrayList<String> KNOWN_FRAGMENTS = new ArrayList<String>();
                    KNOWN_FRAGMENTS.add("org.apache.sling.extensions.webconsolebranding");
                    boolean isFragment = b.getArtifactId().contains("fragment") || KNOWN_FRAGMENTS.contains(b.getArtifactId());
                    String bundleRunModes = b.getRunModes();
                    if (bundleRunModes != null && bundleRunModes.length() > 0) {
                        boolean active = false;
                        for (String m : bundleRunModes.split(",")) {
                            if (!testRunModes.contains(m)) continue;
                            active = true;
                            break;
                        }
                        if (!active) {
                            log.info("Ignoring bundle {} as none of its run modes [{}] are active in this test run {}", new Object[]{b.getArtifactId(), bundleRunModes, testRunModes});
                            continue;
                        }
                    }
                    if (isFragment) {
                        result.add(new Option[]{(Option)CoreOptions.mavenBundle((String)b.getGroupId(), (String)b.getArtifactId(), (String)b.getVersion()).noStart()});
                    } else if (startLevel == 0) {
                        result.add(new Option[]{CoreOptions.mavenBundle((String)b.getGroupId(), (String)b.getArtifactId(), (String)b.getVersion())});
                    } else {
                        result.add(new Option[]{(Option)CoreOptions.mavenBundle((String)b.getGroupId(), (String)b.getArtifactId(), (String)b.getVersion()).startLevel(Integer.valueOf(startLevel))});
                    }
                    log.info("Bundle added: {}/{}/{}", new Object[]{b.getGroupId(), b.getArtifactId(), b.getVersion()});
                }
            }
            log.info("Got {} bundles ({} ignored) from {}", new Object[]{counter, ignored, paxUrl});
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting bundle list " + paxUrl, e);
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
        return result;
    }

    public static CompositeOption slingBootstrapBundles() {
        return new DefaultCompositeOption(new Option[]{CoreOptions.mavenBundle((String)"org.apache.felix", (String)"org.apache.felix.http.jetty", (String)"2.2.0"), CoreOptions.mavenBundle((String)"org.apache.sling", (String)"org.apache.sling.launchpad.api", (String)"1.1.0")});
    }

    public static CompositeOption slingLaunchpadBundles(String version) {
        return SlingPaxOptions.slingBundleList("org.apache.sling", "org.apache.sling.launchpad", version, "xml", "bundlelist");
    }

    public static CompositeOption felixRemoteShellBundles() {
        String gogoVersion = "0.10.0";
        return new DefaultCompositeOption(new Option[]{CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.gogo.runtime").version("0.10.0"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.gogo.shell").version("0.10.0"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.gogo.command").version("0.10.0"), CoreOptions.mavenBundle().groupId("org.apache.felix").artifactId("org.apache.felix.shell.remote").version("1.1.2")});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File dumpMvnUrlToTmpFile(String mvnUrl) throws IOException {
        URL url = new URL(mvnUrl);
        BufferedInputStream is = new BufferedInputStream(url.openStream());
        File tmp = File.createTempFile(SlingPaxOptions.class.getName(), "xml");
        log.debug("Copying bundle list contents to {}", (Object)tmp.getAbsolutePath());
        tmp.deleteOnExit();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmp));
        try {
            byte[] buffer = new byte[16384];
            int len = 0;
            while ((len = ((InputStream)is).read(buffer, 0, buffer.length)) > 0) {
                ((OutputStream)os).write(buffer, 0, len);
            }
            ((OutputStream)os).flush();
        }
        finally {
            ((OutputStream)os).close();
            ((InputStream)is).close();
        }
        return tmp;
    }
}

