/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.producer;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.foundation.common.utils.IOUtils;
import org.apache.servicecomb.registry.RegistrationManager;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class ProducerBootListener
implements BootListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerBootListener.class);
    private static final String PATTERN = File.separator + "microservices" + File.separator + "%s" + File.separator + "%s.yaml";
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private RegistrationManager registrationManager;
    private Environment environment;

    @Autowired
    public void setRegistrationManager(RegistrationManager registrationManager) {
        this.registrationManager = registrationManager;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void onAfterTransport(BootListener.BootEvent event) {
        boolean exportToFile = (Boolean)this.environment.getProperty("servicecomb.swagger.export.enabled", Boolean.TYPE, (Object)true);
        String filePath = (String)this.environment.getProperty("servicecomb.swagger.export.directory", String.class, (Object)TMP_DIR) + PATTERN;
        if (exportToFile) {
            LOGGER.info("export microservice swagger file to path {}", (Object)filePath);
        }
        MicroserviceMeta microserviceMeta = event.getScbEngine().getProducerMicroserviceMeta();
        for (SchemaMeta schemaMeta : microserviceMeta.getSchemaMetas().values()) {
            OpenAPI swagger = schemaMeta.getSwagger();
            String content = SwaggerUtils.swaggerToString((OpenAPI)swagger);
            if (exportToFile) {
                this.exportToFile(String.format(filePath, BootStrapProperties.readServiceName((Environment)this.environment), schemaMeta.getSchemaId()), content);
            } else {
                LOGGER.info("generate swagger for {}/{}/{}, swagger: {}", new Object[]{microserviceMeta.getAppId(), microserviceMeta.getMicroserviceName(), schemaMeta.getSchemaId(), content});
            }
            this.registrationManager.addSchema(schemaMeta.getSchemaId(), content);
        }
    }

    @Override
    public void onAfterClose(BootListener.BootEvent event) {
        MicroserviceMeta microserviceMeta = event.getScbEngine().getProducerMicroserviceMeta();
        if (microserviceMeta == null) {
            return;
        }
        for (OperationMeta operationMeta : microserviceMeta.getOperations()) {
            if (operationMeta.getExecutor() instanceof ExecutorService) {
                ((ExecutorService)operationMeta.getExecutor()).shutdown();
                continue;
            }
            if (operationMeta.getExecutor() instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)((Object)operationMeta.getExecutor())));
                continue;
            }
            LOGGER.warn("Executor {} do not support close or shutdown, it may block service shutdown.", (Object)operationMeta.getExecutor().getClass().getName());
        }
    }

    private void exportToFile(String fileName, String content) {
        File file = new File(fileName);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LOGGER.error("create file directory failed");
            return;
        }
        if (file.exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8, (boolean)false);
            file.setReadOnly();
        }
        catch (IOException e) {
            LOGGER.error("export swagger content to file failed, message: {}", (Object)e.getMessage());
        }
    }
}

