/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics;

import org.springframework.core.env.Environment;

public class MetricsBootstrapConfig {
    public static final String METRICS_WINDOW_TIME = "servicecomb.metrics.window_time";
    public static final String CONFIG_LATENCY_DISTRIBUTION = "servicecomb.metrics.invocation.latencyDistribution";
    public static final String CONFIG_LATENCY_DISTRIBUTION_MIN_SCOPE_LEN = "servicecomb.metrics.publisher.defaultLog.invocation.latencyDistribution.minScopeLength";
    public static final int DEFAULT_METRICS_WINDOW_TIME = 300000;
    private long msPollInterval;
    private String latencyDistribution;
    private int minScopeLength;
    private Environment environment;

    public MetricsBootstrapConfig(Environment environment) {
        this.environment = environment;
        this.msPollInterval = ((Integer)environment.getProperty(METRICS_WINDOW_TIME, Integer.TYPE, (Object)300000)).intValue();
        if (this.msPollInterval < 1000L) {
            this.msPollInterval = 1000L;
        }
        this.latencyDistribution = (String)environment.getProperty(CONFIG_LATENCY_DISTRIBUTION, String.class);
        this.minScopeLength = (Integer)environment.getProperty(CONFIG_LATENCY_DISTRIBUTION_MIN_SCOPE_LEN, Integer.TYPE, (Object)7);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public long getMsPollInterval() {
        return this.msPollInterval;
    }

    public String getLatencyDistribution() {
        return this.latencyDistribution;
    }

    public int getMinScopeLength() {
        return this.minScopeLength;
    }
}

