/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.ByteGetter;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.IntGetter;
import org.apache.servicecomb.foundation.common.utils.bean.ShortGetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public final class Int32WriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Integer.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new IntFieldInt32PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Short.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new ShortFieldInt32PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Byte.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new ByteFieldInt32PrimitiveSchema(protoField, propertyDescriptor);
        }
        return new Int32Schema(protoField, propertyDescriptor);
    }

    private static final class IntFieldInt32PrimitiveSchema<T>
    extends Int32DynamicSchema<T> {
        private final IntGetter<T> primitiveGetter;

        public IntFieldInt32PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (IntGetter)propertyDescriptor.getGetter();
        }

        @Override
        public void getAndWriteTo(OutputEx output, T message) throws IOException {
            int value = this.primitiveGetter.get(message);
            output.writeScalarInt32(this.tag, this.tagSize, value);
        }
    }

    private static final class ShortFieldInt32PrimitiveSchema<T>
    extends Int32DynamicSchema<T> {
        private final ShortGetter<T> primitiveGetter;

        public ShortFieldInt32PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (ShortGetter)propertyDescriptor.getGetter();
        }

        @Override
        public void getAndWriteTo(OutputEx output, T message) throws IOException {
            short value = this.primitiveGetter.get(message);
            output.writeScalarInt32(this.tag, this.tagSize, value);
        }
    }

    private static final class ByteFieldInt32PrimitiveSchema<T>
    extends Int32DynamicSchema<T> {
        private final ByteGetter<T> primitiveGetter;

        public ByteFieldInt32PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (ByteGetter)propertyDescriptor.getGetter();
        }

        @Override
        public void getAndWriteTo(OutputEx output, T message) throws IOException {
            byte value = this.primitiveGetter.get(message);
            output.writeScalarInt32(this.tag, this.tagSize, value);
        }
    }

    private static class Int32Schema<T>
    extends Int32DynamicSchema<T> {
        protected final Getter<T, Object> getter;

        public Int32Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Object value = this.getter.get(message);
            if (value != null) {
                this.writeTo(output, value);
            }
        }
    }

    private static class Int32DynamicSchema<T>
    extends FieldSchema<T> {
        public Int32DynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarInt32(this.tag, this.tagSize, ((Number)value).intValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                int parsedValue = Integer.parseInt(((String[])value)[0], 10);
                output.writeScalarInt32(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                if (((String)value).isEmpty()) {
                    return;
                }
                int parsedValue = Integer.parseInt((String)value, 10);
                output.writeScalarInt32(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

