/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.WireFormat;
import io.protostuff.compiler.model.FieldType;
import io.protostuff.compiler.model.ScalarFieldType;

public final class FieldTypeUtils {
    public static WireFormat.FieldType convert(FieldType fieldType) {
        if (fieldType.isEnum()) {
            return WireFormat.FieldType.ENUM;
        }
        if (fieldType.isScalar()) {
            switch ((ScalarFieldType)fieldType) {
                case INT32: {
                    return WireFormat.FieldType.INT32;
                }
                case INT64: {
                    return WireFormat.FieldType.INT64;
                }
                case UINT32: {
                    return WireFormat.FieldType.UINT32;
                }
                case UINT64: {
                    return WireFormat.FieldType.UINT64;
                }
                case SINT32: {
                    return WireFormat.FieldType.SINT32;
                }
                case SINT64: {
                    return WireFormat.FieldType.SINT64;
                }
                case FIXED32: {
                    return WireFormat.FieldType.FIXED32;
                }
                case FIXED64: {
                    return WireFormat.FieldType.FIXED64;
                }
                case SFIXED32: {
                    return WireFormat.FieldType.SFIXED32;
                }
                case SFIXED64: {
                    return WireFormat.FieldType.SFIXED64;
                }
                case FLOAT: {
                    return WireFormat.FieldType.FLOAT;
                }
                case DOUBLE: {
                    return WireFormat.FieldType.DOUBLE;
                }
                case BOOL: {
                    return WireFormat.FieldType.BOOL;
                }
                case STRING: {
                    return WireFormat.FieldType.STRING;
                }
                case BYTES: {
                    return WireFormat.FieldType.BYTES;
                }
            }
            throw new IllegalStateException("bug: miss process of " + fieldType);
        }
        if (fieldType.isMessage()) {
            return WireFormat.FieldType.MESSAGE;
        }
        throw new IllegalStateException("bug: miss process of " + fieldType);
    }
}

