/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.HashMap;
import java.util.Map;

public class TypesUtil {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    public static final JavaType PRIMITIVE_BYTE;
    public static final JavaType PRIMITIVE_SHORT;
    public static final JavaType PRIMITIVE_INT;
    public static final JavaType PRIMITIVE_LONG;
    public static final JavaType PRIMITIVE_FLOAT;
    public static final JavaType PRIMITIVE_DOUBLE;
    public static final JavaType PRIMITIVE_BOOLEAN;
    public static final JavaType PRIMITIVE_CHAR;
    public static final JavaType PRIMITIVE_WRAPPER_BYTE;
    public static final JavaType PRIMITIVE_WRAPPER_SHORT;
    public static final JavaType PRIMITIVE_WRAPPER_INT;
    public static final JavaType PRIMITIVE_WRAPPER_LONG;
    public static final JavaType PRIMITIVE_WRAPPER_FLOAT;
    public static final JavaType PRIMITIVE_WRAPPER_DOUBLE;
    public static final JavaType PRIMITIVE_WRAPPER_BOOLEAN;
    public static final JavaType PRIMITIVE_WRAPPER_CHAR;
    private static final Map<JavaType, JavaType> PRIMITIVE_TO_WRAPPER_JAVATYPE;
    private static final Map<JavaType, JavaType> WRAPPER_TO_PRIMITIVE_JAVATYPE;

    public static Class<?> primitiveTypeToWrapper(Class<?> primitiveType) {
        return PRIMITIVE_TO_WRAPPER.get(primitiveType);
    }

    public static Class<?> wrapperTypeToPrimitive(Class<?> wrapperType) {
        return WRAPPER_TO_PRIMITIVE.get(wrapperType);
    }

    public static JavaType primitiveJavaTypeToWrapper(JavaType primitiveType) {
        return PRIMITIVE_TO_WRAPPER_JAVATYPE.get(primitiveType);
    }

    public static JavaType wrapperJavaTypeToPrimitive(JavaType wrapperType) {
        return WRAPPER_TO_PRIMITIVE_JAVATYPE.get(wrapperType);
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Character.TYPE, Character.class);
        WRAPPER_TO_PRIMITIVE = new HashMap();
        WRAPPER_TO_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Double.class, Double.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, Character.TYPE);
        PRIMITIVE_BYTE = TypeFactory.defaultInstance().constructType(Byte.TYPE);
        PRIMITIVE_SHORT = TypeFactory.defaultInstance().constructType(Short.TYPE);
        PRIMITIVE_INT = TypeFactory.defaultInstance().constructType(Integer.TYPE);
        PRIMITIVE_LONG = TypeFactory.defaultInstance().constructType(Long.TYPE);
        PRIMITIVE_FLOAT = TypeFactory.defaultInstance().constructType(Float.TYPE);
        PRIMITIVE_DOUBLE = TypeFactory.defaultInstance().constructType(Double.TYPE);
        PRIMITIVE_BOOLEAN = TypeFactory.defaultInstance().constructType(Boolean.TYPE);
        PRIMITIVE_CHAR = TypeFactory.defaultInstance().constructType(Character.TYPE);
        PRIMITIVE_WRAPPER_BYTE = TypeFactory.defaultInstance().constructType(Byte.class);
        PRIMITIVE_WRAPPER_SHORT = TypeFactory.defaultInstance().constructType(Short.class);
        PRIMITIVE_WRAPPER_INT = TypeFactory.defaultInstance().constructType(Integer.class);
        PRIMITIVE_WRAPPER_LONG = TypeFactory.defaultInstance().constructType(Long.class);
        PRIMITIVE_WRAPPER_FLOAT = TypeFactory.defaultInstance().constructType(Float.class);
        PRIMITIVE_WRAPPER_DOUBLE = TypeFactory.defaultInstance().constructType(Double.class);
        PRIMITIVE_WRAPPER_BOOLEAN = TypeFactory.defaultInstance().constructType(Boolean.class);
        PRIMITIVE_WRAPPER_CHAR = TypeFactory.defaultInstance().constructType(Character.class);
        PRIMITIVE_TO_WRAPPER_JAVATYPE = new HashMap<JavaType, JavaType>();
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_BYTE, PRIMITIVE_WRAPPER_BYTE);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_SHORT, PRIMITIVE_WRAPPER_SHORT);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_INT, PRIMITIVE_WRAPPER_INT);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_LONG, PRIMITIVE_WRAPPER_LONG);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_FLOAT, PRIMITIVE_WRAPPER_FLOAT);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_DOUBLE, PRIMITIVE_WRAPPER_DOUBLE);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_BOOLEAN, PRIMITIVE_WRAPPER_BOOLEAN);
        PRIMITIVE_TO_WRAPPER_JAVATYPE.put(PRIMITIVE_CHAR, PRIMITIVE_WRAPPER_CHAR);
        WRAPPER_TO_PRIMITIVE_JAVATYPE = new HashMap<JavaType, JavaType>();
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_BYTE, PRIMITIVE_BYTE);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_SHORT, PRIMITIVE_SHORT);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_INT, PRIMITIVE_INT);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_LONG, PRIMITIVE_LONG);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_FLOAT, PRIMITIVE_FLOAT);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_DOUBLE, PRIMITIVE_DOUBLE);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_BOOLEAN, PRIMITIVE_BOOLEAN);
        WRAPPER_TO_PRIMITIVE_JAVATYPE.put(PRIMITIVE_WRAPPER_CHAR, PRIMITIVE_CHAR);
    }
}

