/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.google.common.eventbus.Subscribe;
import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.WatchedUpdateListener;
import com.netflix.config.WatchedUpdateResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.servicecomb.config.ConfigCenterConfig;
import org.apache.servicecomb.config.TransportUtils;
import org.apache.servicecomb.config.center.client.ConfigCenterAddressManager;
import org.apache.servicecomb.config.center.client.ConfigCenterClient;
import org.apache.servicecomb.config.center.client.ConfigCenterManager;
import org.apache.servicecomb.config.center.client.model.ConfigCenterConfiguration;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsRequest;
import org.apache.servicecomb.config.center.client.model.QueryConfigurationsResponse;
import org.apache.servicecomb.config.common.ConfigConverter;
import org.apache.servicecomb.config.common.ConfigurationChangedEvent;
import org.apache.servicecomb.config.spi.ConfigCenterConfigurationSource;
import org.apache.servicecomb.deployment.Deployment;
import org.apache.servicecomb.deployment.SystemBootstrapInfo;
import org.apache.servicecomb.foundation.auth.AuthHeaderProvider;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.HttpTransport;
import org.apache.servicecomb.http.client.common.HttpTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigCenterConfigurationSourceImpl
implements ConfigCenterConfigurationSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigCenterConfigurationSourceImpl.class);
    private final List<WatchedUpdateListener> listeners = new CopyOnWriteArrayList<WatchedUpdateListener>();
    private ConfigCenterManager configCenterManager;
    private ConfigConverter configConverter;

    public int getOrder() {
        return 200;
    }

    public boolean isValidSource(Configuration localConfiguration) {
        ConfigCenterConfig.setConcurrentCompositeConfiguration((ConcurrentCompositeConfiguration)localConfiguration);
        SystemBootstrapInfo address = Deployment.getSystemBootStrapInfo((String)"ConfigCenter");
        if (address == null) {
            LOGGER.info("config center server is not configured.");
            return false;
        }
        return true;
    }

    public void init(Configuration localConfiguration) {
        this.configConverter = new ConfigConverter(ConfigCenterConfig.INSTANCE.getFileSources());
        ConfigCenterAddressManager configCenterAddressManager = this.configCenterAddressManager();
        HttpTransport httpTransport = this.createHttpTransport(configCenterAddressManager, this.buildRequestConfig(localConfiguration), localConfiguration);
        ConfigCenterClient configCenterClient = new ConfigCenterClient(configCenterAddressManager, httpTransport);
        EventManager.register((Object)this);
        ConfigCenterConfiguration configCenterConfiguration = this.createConfigCenterConfiguration();
        QueryConfigurationsRequest queryConfigurationsRequest = this.firstPull(configCenterClient, configCenterAddressManager);
        this.configCenterManager = new ConfigCenterManager(configCenterClient, EventManager.getEventBus(), this.configConverter, configCenterConfiguration, configCenterAddressManager);
        this.configCenterManager.setQueryConfigurationsRequest(queryConfigurationsRequest);
        this.configCenterManager.startConfigCenterManager();
    }

    private RequestConfig buildRequestConfig(Configuration configuration) {
        RequestConfig.Builder builder = HttpTransportFactory.defaultRequestConfig();
        builder.setConnectTimeout(ConfigCenterConfig.INSTANCE.getConnectTimeout(configuration));
        builder.setConnectionRequestTimeout(ConfigCenterConfig.INSTANCE.getConnectionRequestTimeout(configuration));
        builder.setSocketTimeout(ConfigCenterConfig.INSTANCE.getSocketTimeout(configuration));
        return builder.build();
    }

    private QueryConfigurationsRequest firstPull(ConfigCenterClient configCenterClient, ConfigCenterAddressManager configCenterAddressManager) {
        QueryConfigurationsRequest queryConfigurationsRequest = this.createQueryConfigurationsRequest();
        try {
            QueryConfigurationsResponse response = configCenterClient.queryConfigurations(queryConfigurationsRequest, configCenterAddressManager.address());
            if (response.isChanged()) {
                this.configConverter.updateData(response.getConfigurations());
                this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)this.configConverter.getCurrentData(), null, null));
                queryConfigurationsRequest.setRevision(response.getRevision());
            }
        }
        catch (Exception e) {
            if (ConfigCenterConfig.INSTANCE.firstPullRequired()) {
                throw e;
            }
            LOGGER.warn("first pull failed, and ignore {}", (Object)e.getMessage());
        }
        return queryConfigurationsRequest;
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        this.updateConfiguration(WatchedUpdateResult.createIncremental((Map)event.getAdded(), (Map)event.getUpdated(), (Map)event.getDeleted()));
    }

    private QueryConfigurationsRequest createQueryConfigurationsRequest() {
        QueryConfigurationsRequest request = new QueryConfigurationsRequest();
        request.setApplication(ConfigCenterConfig.INSTANCE.getAppName());
        request.setServiceName(ConfigCenterConfig.INSTANCE.getServiceName());
        request.setVersion(ConfigCenterConfig.INSTANCE.getServiceVersion());
        request.setEnvironment(ConfigCenterConfig.INSTANCE.getEnvironment());
        request.setRevision(null);
        return request;
    }

    private ConfigCenterConfiguration createConfigCenterConfiguration() {
        return new ConfigCenterConfiguration().setRefreshIntervalInMillis(ConfigCenterConfig.INSTANCE.getRefreshInterval());
    }

    private HttpTransport createHttpTransport(ConfigCenterAddressManager configCenterAddressManager, RequestConfig requestConfig, Configuration localConfiguration) {
        List authHeaderProviders = SPIServiceUtils.getOrLoadSortedService(AuthHeaderProvider.class);
        if (ConfigCenterConfig.INSTANCE.isProxyEnable().booleanValue()) {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
            HttpHost proxy = new HttpHost(ConfigCenterConfig.INSTANCE.getProxyHost(), ConfigCenterConfig.INSTANCE.getProxyPort(), "http");
            httpClientBuilder.setProxy(proxy);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(ConfigCenterConfig.INSTANCE.getProxyUsername(), ConfigCenterConfig.INSTANCE.getProxyPasswd()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(configCenterAddressManager.sslEnabled(), localConfiguration, "cc.consumer"), (RequestAuthHeaderProvider)ConfigCenterConfigurationSourceImpl.getRequestAuthHeaderProvider(authHeaderProviders), (HttpClientBuilder)httpClientBuilder);
        }
        return HttpTransportFactory.createHttpTransport((HttpConfiguration.SSLProperties)TransportUtils.createSSLProperties(configCenterAddressManager.sslEnabled(), localConfiguration, "cc.consumer"), (RequestAuthHeaderProvider)ConfigCenterConfigurationSourceImpl.getRequestAuthHeaderProvider(authHeaderProviders), (RequestConfig)requestConfig);
    }

    private static RequestAuthHeaderProvider getRequestAuthHeaderProvider(List<AuthHeaderProvider> authHeaderProviders) {
        return signRequest -> {
            HashMap headers = new HashMap();
            authHeaderProviders.forEach(provider -> headers.putAll(provider.authHeaders()));
            return headers;
        };
    }

    private ConfigCenterAddressManager configCenterAddressManager() {
        return new ConfigCenterAddressManager(ConfigCenterConfig.INSTANCE.getDomainName(), Deployment.getSystemBootStrapInfo((String)"ConfigCenter").getAccessURL(), EventManager.getEventBus());
    }

    private void updateConfiguration(WatchedUpdateResult result) {
        LOGGER.info("configuration changed keys, added=[{}], updated=[{}], deleted=[{}]", new Object[]{result.getAdded() == null ? "" : result.getAdded().keySet(), result.getChanged() == null ? "" : result.getChanged().keySet(), result.getDeleted() == null ? "" : result.getDeleted().keySet()});
        for (WatchedUpdateListener l : this.listeners) {
            try {
                l.updateConfiguration(result);
            }
            catch (Throwable ex) {
                LOGGER.error("Error in invoking WatchedUpdateListener", ex);
            }
        }
    }

    public void destroy() {
        if (this.configCenterManager == null) {
            return;
        }
        this.configCenterManager.stop();
    }

    public void addUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.add(watchedUpdateListener);
    }

    public void removeUpdateListener(WatchedUpdateListener watchedUpdateListener) {
        this.listeners.remove(watchedUpdateListener);
    }

    public Map<String, Object> getCurrentData() throws Exception {
        return Collections.emptyMap();
    }
}

