/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.netflix.config.ConcurrentCompositeConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.BootStrapProperties;
import org.apache.servicecomb.deployment.Deployment;

public final class ConfigCenterConfig {
    public static final ConfigCenterConfig INSTANCE = new ConfigCenterConfig();
    public static final String SSL_TAG = "cc.consumer";
    private static ConcurrentCompositeConfiguration finalConfig;
    private static final String AUTO_DISCOVERY_ENABLED = "servicecomb.service.registry.autodiscovery";
    private static final String DOMAIN_NAME = "servicecomb.config.client.domainName";
    private static final String REFRESH_INTERVAL = "servicecomb.config.client.refresh_interval";
    private static final String FIRST_REFRESH_INTERVAL = "servicecomb.config.client.first_refresh_interval";
    private static final String FIRST_PULL_REQUIRED = "servicecomb.config.client.firstPullRequired";
    public static final String FILE_SOURCE = "servicecomb.config.client.fileSource";
    private static final int DEFAULT_REFRESH_INTERVAL = 15000;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;
    private static final String CLIENT_CONNECT_TIMEOUT = "servicecomb.config.client.timeout.connect";
    private static final String CLIENT_REQUEST_TIMEOUT = "servicecomb.config.client.timeout.request";
    private static final String CLIENT_SOCKET_TIMEOUT = "servicecomb.config.client.timeout.socket";

    private ConfigCenterConfig() {
    }

    public static void setConcurrentCompositeConfiguration(ConcurrentCompositeConfiguration config) {
        finalConfig = config;
    }

    public static ConcurrentCompositeConfiguration getConcurrentCompositeConfiguration() {
        return finalConfig;
    }

    public String getDomainName() {
        return finalConfig.getString(DOMAIN_NAME, "default");
    }

    public boolean firstPullRequired() {
        return finalConfig.getBoolean(FIRST_PULL_REQUIRED, false);
    }

    public List<String> getFileSources() {
        Object property = finalConfig.getProperty(FILE_SOURCE);
        if (property instanceof String) {
            return new ArrayList<String>(Arrays.asList(((String)property).split(",")));
        }
        if (property instanceof List) {
            return (List)property;
        }
        return Collections.EMPTY_LIST;
    }

    public long getRefreshInterval() {
        return finalConfig.getLong(REFRESH_INTERVAL, 15000L);
    }

    public int getFirstRefreshInterval() {
        return finalConfig.getInt(FIRST_REFRESH_INTERVAL, 0);
    }

    public Boolean isProxyEnable() {
        return finalConfig.getBoolean("servicecomb.proxy.enable", false);
    }

    public String getProxyHost() {
        return finalConfig.getString("servicecomb.proxy.host", "127.0.0.1");
    }

    public int getProxyPort() {
        return finalConfig.getInt("servicecomb.proxy.port", 8080);
    }

    public String getProxyUsername() {
        return finalConfig.getString("servicecomb.proxy.username", null);
    }

    public String getProxyPasswd() {
        return finalConfig.getString("servicecomb.proxy.passwd", null);
    }

    public String getServiceName() {
        return BootStrapProperties.readServiceName((Configuration)finalConfig);
    }

    public String getAppName() {
        return BootStrapProperties.readApplication((Configuration)finalConfig);
    }

    public String getServiceVersion() {
        return BootStrapProperties.readServiceVersion((Configuration)finalConfig);
    }

    public List<String> getServerUri() {
        return Deployment.getSystemBootStrapInfo((String)"ConfigCenter").getAccessURL();
    }

    public boolean getAutoDiscoveryEnabled() {
        return finalConfig.getBoolean(AUTO_DISCOVERY_ENABLED, false);
    }

    public String getEnvironment() {
        return BootStrapProperties.readServiceEnvironment((Configuration)finalConfig);
    }

    public int getConnectTimeout(Configuration localConfiguration) {
        return localConfiguration.getInt(CLIENT_CONNECT_TIMEOUT, 5000);
    }

    public int getConnectionRequestTimeout(Configuration configuration) {
        return configuration.getInt(CLIENT_REQUEST_TIMEOUT, 5000);
    }

    public int getSocketTimeout(Configuration configuration) {
        return configuration.getInt(CLIENT_SOCKET_TIMEOUT, 5000);
    }
}

