/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.LongSetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar.AbstractScalarReadSchemas;

public class UInt64ReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Long.TYPE.equals(javaType.getRawClass())) {
            return new UInt64PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Long.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new UInt64Schema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class UInt64PrimitiveSchema<T>
    extends FieldSchema<T> {
        protected final LongSetter<T> setter;

        public UInt64PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
            this.setter = (LongSetter)propertyDescriptor.getSetter();
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            long value = input.readUInt64();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class UInt64Schema<T>
    extends AbstractScalarReadSchemas.AbstractLongSchema<T> {
        public UInt64Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            long value = input.readUInt64();
            this.setter.set(message, (Object)value);
            return input.readFieldNumber();
        }
    }
}

