/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.validator;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.ParameterNameProvider;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class DefaultParameterNameProvider
implements ParameterNameProvider {
    private final Map<AccessibleObject, List<String>> methodCache = new ConcurrentHashMapEx();

    public List<String> getParameterNames(Constructor<?> constructor) {
        return this.methodCache.computeIfAbsent(constructor, k -> this.getParameterNamesEx(constructor));
    }

    public List<String> getParameterNames(Method method) {
        return this.methodCache.computeIfAbsent(method, k -> this.getParameterNamesEx(method));
    }

    private List<String> getParameterNamesEx(Executable methodOrConstructor) {
        Parameter[] parameters = methodOrConstructor.getParameters();
        ArrayList<String> parameterNames = new ArrayList<String>(parameters.length);
        for (int idx = 0; idx < parameters.length; ++idx) {
            Parameter parameter = parameters[idx];
            String parameterName = parameter.isNamePresent() ? parameter.getName() : "arg" + idx;
            parameterNames.add(parameterName);
        }
        return Collections.unmodifiableList(parameterNames);
    }
}

