/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.param;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.netflix.config.DynamicPropertyFactory;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodecsUtils;
import org.apache.servicecomb.common.rest.codec.param.AbstractParamProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessor;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreator;
import org.apache.servicecomb.common.rest.codec.param.ParamValueProcessorCreatorManager;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class HeaderProcessorCreator
implements ParamValueProcessorCreator {
    public static final String PARAMTYPE = "header";

    public HeaderProcessorCreator() {
        ParamValueProcessorCreatorManager.INSTANCE.register(PARAMTYPE, this);
    }

    @Override
    public ParamValueProcessor create(Parameter parameter, Type genericParamType) {
        JavaType targetType = genericParamType == null ? null : TypeFactory.defaultInstance().constructType(genericParamType);
        return new HeaderProcessor((HeaderParameter)parameter, targetType);
    }

    public static class HeaderProcessor
    extends AbstractParamProcessor {
        private final boolean ignoreRequiredCheck = DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.rest.parameter.header.ignoreRequiredCheck", false).get();
        private final HeaderCodec headerCodec;

        public HeaderProcessor(HeaderParameter headerParameter, JavaType targetType) {
            super(headerParameter.getName(), targetType, headerParameter.getDefaultValue(), headerParameter.getRequired());
            this.headerCodec = ArrayProperty.isType((String)headerParameter.getType()) && headerParameter.getCollectionFormat() == null ? HeaderCodecsUtils.find("multi") : HeaderCodecsUtils.find(headerParameter.getCollectionFormat());
        }

        @Override
        public Object getValue(HttpServletRequest request) {
            return this.headerCodec.decode(this, request);
        }

        public Object checkRequiredAndDefaultValue() {
            if (!this.ignoreRequiredCheck && this.isRequired()) {
                throw new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, "Parameter is required.");
            }
            return this.getDefaultValue();
        }

        @Override
        public void setValue(RestClientRequest clientRequest, Object arg) throws Exception {
            this.headerCodec.encode(clientRequest, this.paramPath, arg);
        }

        @Override
        public String getProcessorType() {
            return HeaderProcessorCreator.PARAMTYPE;
        }
    }
}

