/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.cache;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.netflix.hystrix.contrib.javanica.cache.CacheInvocationParameter;
import com.netflix.hystrix.contrib.javanica.command.ExecutionType;
import com.netflix.hystrix.contrib.javanica.command.MethodExecutionAction;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class CacheInvocationContext<A extends Annotation> {
    private final Method method;
    private final Object target;
    private final MethodExecutionAction cacheKeyMethod;
    private final ExecutionType executionType = ExecutionType.SYNCHRONOUS;
    private final A cacheAnnotation;
    private List<CacheInvocationParameter> parameters = Collections.emptyList();
    private List<CacheInvocationParameter> keyParameters = Collections.emptyList();

    public CacheInvocationContext(A cacheAnnotation, MethodExecutionAction cacheKeyMethod, Object target, Method method, Object ... args) {
        this.method = method;
        this.target = target;
        this.cacheKeyMethod = cacheKeyMethod;
        this.cacheAnnotation = cacheAnnotation;
        Class<?>[] parametersTypes = method.getParameterTypes();
        int parameterCount = parametersTypes.length;
        if (parameterCount > 0) {
            Annotation[][] parametersAnnotations = method.getParameterAnnotations();
            ImmutableList.Builder parametersBuilder = ImmutableList.builder();
            for (int pos = 0; pos < parameterCount; ++pos) {
                Class<?> paramType = parametersTypes[pos];
                Object val = args[pos];
                parametersBuilder.add((Object)new CacheInvocationParameter(paramType, val, parametersAnnotations[pos], pos));
            }
            this.parameters = parametersBuilder.build();
            Iterable filtered = Iterables.filter(this.parameters, (Predicate)new Predicate<CacheInvocationParameter>(){

                public boolean apply(CacheInvocationParameter input) {
                    return input.hasCacheKeyAnnotation();
                }
            });
            this.keyParameters = filtered.iterator().hasNext() ? ImmutableList.builder().addAll(filtered).build() : this.parameters;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getTarget() {
        return this.target;
    }

    public A getCacheAnnotation() {
        return this.cacheAnnotation;
    }

    public List<CacheInvocationParameter> getAllParameters() {
        return this.parameters;
    }

    public List<CacheInvocationParameter> getKeyParameters() {
        return this.keyParameters;
    }

    public boolean hasKeyParameters() {
        return !this.keyParameters.isEmpty();
    }

    public String getCacheKeyMethodName() {
        return this.cacheKeyMethod != null ? this.cacheKeyMethod.getMethod().getName() : null;
    }

    public MethodExecutionAction getCacheKeyMethod() {
        return this.cacheKeyMethod;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }
}

