/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ;

import io.vertx.ext.web.common.WebEnvironment;
import io.vertx.ext.web.impl.ConcurrentLRUCache;
import io.vertx.ext.web.templ.TemplateEngine;
import java.util.Objects;

public abstract class CachingTemplateEngine<T>
implements TemplateEngine {
    private final boolean enableCache = !WebEnvironment.development();
    protected final ConcurrentLRUCache<String, T> cache;
    protected String extension;

    protected CachingTemplateEngine(String ext, int maxCacheSize) {
        Objects.requireNonNull(ext);
        if (maxCacheSize < 1) {
            throw new IllegalArgumentException("maxCacheSize must be >= 1");
        }
        this.doSetExtension(ext);
        this.cache = new ConcurrentLRUCache(maxCacheSize);
    }

    @Override
    public boolean isCachingEnabled() {
        return this.enableCache;
    }

    protected String adjustLocation(String location) {
        if (!location.endsWith(this.extension)) {
            location = location + this.extension;
        }
        return location;
    }

    protected void doSetExtension(String ext) {
        this.extension = ext.charAt(0) == '.' ? ext : "." + ext;
    }
}

