/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cache;

import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.springframework.boot.actuate.cache.AbstractJmxCacheStatisticsProvider;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.DefaultCacheStatistics;
import org.springframework.cache.jcache.JCacheCache;

public class JCacheCacheStatisticsProvider
extends AbstractJmxCacheStatisticsProvider<JCacheCache> {
    @Override
    protected ObjectName getObjectName(JCacheCache cache) throws MalformedObjectNameException {
        ObjectName name = new ObjectName("javax.cache:type=CacheStatistics,Cache=" + cache.getName() + ",*");
        Set<ObjectInstance> instances = this.getMBeanServer().queryMBeans(name, null);
        if (instances.size() == 1) {
            return instances.iterator().next().getObjectName();
        }
        return null;
    }

    @Override
    protected CacheStatistics getCacheStatistics(ObjectName objectName) {
        DefaultCacheStatistics statistics = new DefaultCacheStatistics();
        Float hitPercentage = this.getAttribute(objectName, "CacheHitPercentage", Float.class);
        Float missPercentage = this.getAttribute(objectName, "CacheMissPercentage", Float.class);
        if (hitPercentage != null && missPercentage != null && (hitPercentage.floatValue() > 0.0f || missPercentage.floatValue() > 0.0f)) {
            statistics.setHitRatio((double)hitPercentage.floatValue() / 100.0);
            statistics.setMissRatio((double)missPercentage.floatValue() / 100.0);
        }
        return statistics;
    }
}

