/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cache;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.metrics.Metric;

public class DefaultCacheStatistics
implements CacheStatistics {
    private Long size;
    private Double hitRatio;
    private Double missRatio;

    @Override
    public Collection<Metric<?>> toMetrics(String prefix) {
        ArrayList result = new ArrayList();
        this.addMetric(result, prefix + "size", this.getSize());
        this.addMetric(result, prefix + "hit.ratio", this.getHitRatio());
        this.addMetric(result, prefix + "miss.ratio", this.getMissRatio());
        return result;
    }

    public void setGetCacheCounts(long hitCount, long missCount) {
        long total = hitCount + missCount;
        if (total > 0L) {
            double hitRatio = (double)hitCount / (double)total;
            this.setHitRatio(hitRatio);
            this.setMissRatio(1.0 - hitRatio);
        }
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public Double getHitRatio() {
        return this.hitRatio;
    }

    public void setHitRatio(Double hitRatio) {
        this.hitRatio = hitRatio;
    }

    @Override
    public Double getMissRatio() {
        return this.missRatio;
    }

    public void setMissRatio(Double missRatio) {
        this.missRatio = missRatio;
    }

    private <T extends Number> void addMetric(Collection<Metric<?>> metrics, String name, T value) {
        if (value != null) {
            metrics.add(new Metric<T>(name, value));
        }
    }
}

