/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.Server;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingUrl
implements IPing {
    private static final Logger LOGGER = LoggerFactory.getLogger(PingUrl.class);
    String pingAppendString = "";
    boolean isSecure = false;
    String expectedContent = null;

    public PingUrl() {
    }

    public PingUrl(boolean isSecure, String pingAppendString) {
        this.isSecure = isSecure;
        this.pingAppendString = pingAppendString != null ? pingAppendString : "";
    }

    public void setPingAppendString(String pingAppendString) {
        this.pingAppendString = pingAppendString != null ? pingAppendString : "";
    }

    public String getPingAppendString() {
        return this.pingAppendString;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setExpectedContent(String expectedContent) {
        this.expectedContent = expectedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive(Server server) {
        String urlStr = "";
        urlStr = this.isSecure ? "https://" : "http://";
        urlStr = urlStr + server.getId();
        urlStr = urlStr + this.getPingAppendString();
        boolean isAlive = false;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpGet getRequest = new HttpGet(urlStr);
        String content = null;
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)getRequest);
            content = EntityUtils.toString((HttpEntity)response.getEntity());
            boolean bl = isAlive = response.getStatusLine().getStatusCode() == 200;
            if (this.getExpectedContent() != null) {
                LOGGER.debug("content:" + content);
                isAlive = content == null ? false : content.equals(this.getExpectedContent());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            getRequest.abort();
        }
        return isAlive;
    }

    public static void main(String[] args) {
        PingUrl p = new PingUrl(false, "/cs/hostRunning");
        p.setExpectedContent("true");
        Server s = new Server("ec2-75-101-231-85.compute-1.amazonaws.com", 7101);
        boolean isAlive = p.isAlive(s);
        System.out.println("isAlive:" + isAlive);
    }
}

