/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Dispatcher;
import reactor.core.support.Assert;
import reactor.fn.Consumer;

public class TraceableDelegatingDispatcher
implements Dispatcher {
    private final Dispatcher delegate;
    private final Logger log;

    public TraceableDelegatingDispatcher(Dispatcher delegate) {
        Assert.notNull(delegate, "Delegate Dispatcher cannot be null.");
        this.delegate = delegate;
        this.log = LoggerFactory.getLogger(delegate.getClass());
    }

    @Override
    public boolean alive() {
        return this.delegate.alive();
    }

    @Override
    public boolean awaitAndShutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("awaitAndShutdown()");
        }
        return this.delegate.awaitAndShutdown();
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("awaitAndShutdown({}, {})", (Object)timeout, (Object)timeUnit);
        }
        return this.delegate.awaitAndShutdown(timeout, timeUnit);
    }

    @Override
    public void shutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("shutdown()");
        }
        this.delegate.shutdown();
    }

    @Override
    public void forceShutdown() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("forceShutdown()");
        }
        this.delegate.forceShutdown();
    }

    @Override
    public <E> void tryDispatch(E event, Consumer<E> eventConsumer, Consumer<Throwable> errorConsumer) {
        this.dispatch(event, eventConsumer, errorConsumer);
    }

    @Override
    public <E> void dispatch(E event, Consumer<E> consumer, Consumer<Throwable> errorConsumer) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("dispatch({}, {}, {})", new Object[]{event, consumer, errorConsumer});
        }
        this.delegate.dispatch(event, consumer, errorConsumer);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }

    @Override
    public boolean supportsOrdering() {
        return this.delegate.supportsOrdering();
    }

    @Override
    public long remainingSlots() {
        return this.delegate.remainingSlots();
    }

    @Override
    public long backlogSize() {
        return this.delegate.backlogSize();
    }

    @Override
    public boolean inContext() {
        return this.delegate.inContext();
    }
}

