/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.ChainAuth;
import io.vertx.ext.auth.User;
import java.util.ArrayList;
import java.util.List;

public class ChainAuthImpl
implements ChainAuth {
    private final List<AuthProvider> providers = new ArrayList<AuthProvider>();

    @Override
    public ChainAuth append(AuthProvider other) {
        this.providers.add(other);
        return this;
    }

    @Override
    public boolean remove(AuthProvider other) {
        return this.providers.remove(other);
    }

    @Override
    public void clear() {
        this.providers.clear();
    }

    @Override
    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.iterate(0, authInfo, resultHandler);
    }

    private void iterate(int idx, JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        if (idx >= this.providers.size()) {
            resultHandler.handle((Object)Future.failedFuture((String)"No more providers in the auth chain."));
            return;
        }
        this.providers.get(idx).authenticate(authInfo, (Handler<AsyncResult<User>>)((Handler)res -> {
            if (res.succeeded()) {
                resultHandler.handle(res);
            } else {
                this.iterate(idx + 1, authInfo, resultHandler);
            }
        }));
    }
}

