/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.web.cors.CorsConfiguration;

public class CorsRegistration {
    private final String pathPattern;
    private final CorsConfiguration config;

    public CorsRegistration(String pathPattern) {
        this.pathPattern = pathPattern;
        this.config = new CorsConfiguration().applyPermitDefaultValues();
    }

    public CorsRegistration allowedOrigins(String ... origins) {
        this.config.setAllowedOrigins(new ArrayList<String>(Arrays.asList(origins)));
        return this;
    }

    public CorsRegistration allowedMethods(String ... methods) {
        this.config.setAllowedMethods(new ArrayList<String>(Arrays.asList(methods)));
        return this;
    }

    public CorsRegistration allowedHeaders(String ... headers2) {
        this.config.setAllowedHeaders(new ArrayList<String>(Arrays.asList(headers2)));
        return this;
    }

    public CorsRegistration exposedHeaders(String ... headers2) {
        this.config.setExposedHeaders(new ArrayList<String>(Arrays.asList(headers2)));
        return this;
    }

    public CorsRegistration allowCredentials(boolean allowCredentials) {
        this.config.setAllowCredentials(Boolean.valueOf(allowCredentials));
        return this;
    }

    public CorsRegistration maxAge(long maxAge) {
        this.config.setMaxAge(Long.valueOf(maxAge));
        return this;
    }

    protected String getPathPattern() {
        return this.pathPattern;
    }

    protected CorsConfiguration getCorsConfiguration() {
        return this.config;
    }
}

