/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.zuul.filters.pre;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.DispatcherServlet;

public class ServletDetectionFilter
extends ZuulFilter {
    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -3;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        if (!(request instanceof HttpServletRequestWrapper) && this.isDispatcherServletRequest(request)) {
            ctx.set("isDispatcherServletRequest", (Object)true);
        } else {
            ctx.set("isDispatcherServletRequest", (Object)false);
        }
        return null;
    }

    private boolean isDispatcherServletRequest(HttpServletRequest request) {
        return request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null;
    }
}

