/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.archaius;

import com.netflix.config.ConfigurationManager;
import org.apache.commons.configuration.AbstractConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class ArchaiusDelegatingProxyUtils {
    public static String APPLICATION_CONTEXT = ApplicationContext.class.getName();

    public static <T> T getNamedInstance(Class<T> type, String name) {
        ApplicationContext context = (ApplicationContext)ConfigurationManager.getConfigInstance().getProperty(APPLICATION_CONTEXT);
        return (T)(context != null && context.containsBean(name) ? context.getBean(name, type) : null);
    }

    public static <T> T getInstanceWithPrefix(Class<T> type, String prefix) {
        String name = prefix + type.getSimpleName();
        return ArchaiusDelegatingProxyUtils.getNamedInstance(type, name);
    }

    public static void addApplicationContext(ConfigurableApplicationContext context) {
        AbstractConfiguration config = ConfigurationManager.getConfigInstance();
        config.clearProperty(APPLICATION_CONTEXT);
        config.setProperty(APPLICATION_CONTEXT, (Object)context);
    }
}

