/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy.processor;

import com.netflix.ribbon.proxy.processor.AnnotationProcessor;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AnnotationProcessorsProvider {
    public static final AnnotationProcessorsProvider DEFAULT = new DefaultAnnotationProcessorsProvider();
    private final List<AnnotationProcessor> processors = new CopyOnWriteArrayList<AnnotationProcessor>();

    public void register(AnnotationProcessor processor) {
        this.processors.add(processor);
    }

    public List<AnnotationProcessor> getProcessors() {
        return this.processors;
    }

    public static class DefaultAnnotationProcessorsProvider
    extends AnnotationProcessorsProvider {
        protected DefaultAnnotationProcessorsProvider() {
            ServiceLoader<AnnotationProcessor> loader = ServiceLoader.load(AnnotationProcessor.class);
            Iterator<AnnotationProcessor> iterator = loader.iterator();
            while (iterator.hasNext()) {
                this.register(iterator.next());
            }
        }
    }
}

