/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon;

import com.netflix.client.config.ClientConfigFactory;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.ribbon.CacheProvider;
import com.netflix.ribbon.ClientOptions;
import com.netflix.ribbon.RequestTemplate;
import com.netflix.ribbon.ResponseValidator;
import com.netflix.ribbon.RibbonTransportFactory;
import com.netflix.ribbon.hystrix.FallbackHandler;

public abstract class ResourceGroup<T extends RequestTemplate<?, ?>> {
    protected final String name;
    protected final IClientConfig clientConfig;
    protected final ClientConfigFactory configFactory;
    protected final RibbonTransportFactory transportFactory;

    protected ResourceGroup(String name) {
        this(name, ClientOptions.create(), ClientConfigFactory.DEFAULT, RibbonTransportFactory.DEFAULT);
    }

    protected ResourceGroup(String name, ClientOptions options, ClientConfigFactory configFactory, RibbonTransportFactory transportFactory) {
        this.name = name;
        this.clientConfig = configFactory.newConfig();
        this.clientConfig.loadProperties(name);
        if (options != null) {
            for (IClientConfigKey<?> key : options.getOptions().keySet()) {
                this.clientConfig.set(key, options.getOptions().get(key));
            }
        }
        this.configFactory = configFactory;
        this.transportFactory = transportFactory;
    }

    protected final IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public final String name() {
        return this.name;
    }

    public abstract <S> TemplateBuilder<S, ?, ?> newTemplateBuilder(String var1, Class<? extends S> var2);

    public static abstract class TemplateBuilder<S, R, T extends RequestTemplate<S, R>> {
        public abstract TemplateBuilder withFallbackProvider(FallbackHandler<S> var1);

        public abstract TemplateBuilder withResponseValidator(ResponseValidator<R> var1);

        public abstract TemplateBuilder withRequestCacheKey(String var1);

        public abstract TemplateBuilder withCacheProvider(String var1, CacheProvider<S> var2);

        public abstract TemplateBuilder withHystrixProperties(HystrixObservableCommand.Setter var1);

        public abstract T build();
    }

    public static abstract class GroupBuilder<T extends ResourceGroup> {
        public abstract T build();

        public abstract GroupBuilder withClientOptions(ClientOptions var1);
    }
}

