/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.css.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.Name;
import org.apache.royale.abc.visitors.IABCVisitor;
import org.apache.royale.abc.visitors.IMethodBodyVisitor;
import org.apache.royale.abc.visitors.IMethodVisitor;
import org.apache.royale.abc.visitors.ITraitsVisitor;
import org.apache.royale.compiler.css.ICSSDocument;
import org.apache.royale.compiler.css.ICSSNode;
import org.apache.royale.compiler.css.ICSSProperty;
import org.apache.royale.compiler.css.ICSSPropertyValue;
import org.apache.royale.compiler.css.ICSSSelector;
import org.apache.royale.compiler.css.ICSSSelectorCondition;
import org.apache.royale.compiler.definitions.references.IResolvedQualifiersReference;
import org.apache.royale.compiler.definitions.references.ReferenceFactory;
import org.apache.royale.compiler.internal.as.codegen.ABCGeneratingReducer;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.internal.css.CSSArrayPropertyValue;
import org.apache.royale.compiler.internal.css.CSSColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSFontFace;
import org.apache.royale.compiler.internal.css.CSSFunctionCallPropertyValue;
import org.apache.royale.compiler.internal.css.CSSKeywordPropertyValue;
import org.apache.royale.compiler.internal.css.CSSMultiValuePropertyValue;
import org.apache.royale.compiler.internal.css.CSSNumberPropertyValue;
import org.apache.royale.compiler.internal.css.CSSRgbColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSRgbaColorPropertyValue;
import org.apache.royale.compiler.internal.css.CSSRule;
import org.apache.royale.compiler.internal.css.CSSSelector;
import org.apache.royale.compiler.internal.css.CSSStringPropertyValue;
import org.apache.royale.compiler.internal.css.codegen.CSSCompilationSession;
import org.apache.royale.compiler.internal.css.codegen.ICSSCodeGenResult;
import org.apache.royale.compiler.internal.css.codegen.ICSSRuntimeConstants;
import org.apache.royale.compiler.internal.css.codegen.Pair;
import org.apache.royale.compiler.internal.css.semantics.CSSSemanticAnalyzer;
import org.apache.royale.compiler.internal.units.EmbedCompilationUnit;
import org.apache.royale.compiler.problems.CSSCodeGenProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.projects.IRoyaleProject;

public class CSSReducer
implements ICSSCodeGenResult {
    private static final String GLOBAL_SELECTOR = "global";
    public static final String FONTFACE_ARRAY = "fontFaces";
    public static final String FACTORY_FUNCTIONS = "factoryFunctions";
    public static final String INHERITING_STYLES = "inheritingStyles";
    public static final String DATA_ARRAY = "data";
    private static final Name NAME_INHERITING_STYLES = new Name("inheritingStyles");
    public static final Name NAME_DATA_ARRAY = new Name("data");
    public static final Name NAME_FONTFACE_ARRAY = new Name("fontFaces");
    public static final Name NAME_FACTORY_FUNCTIONS = new Name("factoryFunctions");
    private static final Vector<Name> EMPTY_PARAM_TYPES = new Vector();
    private final int styleTagIndex;
    private final CSSCompilationSession session;
    private final Set<ICompilerProblem> problems;
    private final ImmutableMap<ICSSSelector, String> resolvedSelectors;
    private final IABCVisitor abcVisitor;
    private InstructionList cinitInstructionList;
    private final IRoyaleProject project;
    private final Integer factory;
    private String mediaQueryString;
    private ArrayList<String> fontFaces = new ArrayList();
    private HashMap<String, ArrayList<String>> mediaQueryMap = new HashMap();

    public CSSReducer(IRoyaleProject project, ICSSDocument cssDocument, IABCVisitor abcVisitor, CSSCompilationSession session, boolean isDefaultFactory, int styleTagIndex) {
        assert (project != null) : "Expected a Flex project.";
        assert (cssDocument != null) : "Expected a CSS model.";
        assert (abcVisitor != null) : "Expected an ABC visitor.";
        assert (session != null) : "Expected a CSSCompilationSession.";
        this.styleTagIndex = styleTagIndex;
        this.problems = new HashSet<ICompilerProblem>();
        this.session = session;
        this.resolvedSelectors = ImmutableMap.copyOf(session.resolvedSelectors);
        this.abcVisitor = abcVisitor;
        this.project = project;
        this.factory = isDefaultFactory ? ICSSRuntimeConstants.DEFAULT_FACTORY : ICSSRuntimeConstants.FACTORY;
    }

    public Pair.PairOfInstructionLists reduceDocument(ICSSNode site, Pair.PairOfInstructionLists namespaceList, Pair.PairOfInstructionLists ruleList) {
        int elementSize = ((InstructionList)ruleList.arrayReduction).getInstructions().size();
        InstructionList arrayInstructions = new InstructionList();
        arrayInstructions.addAll((InstructionList)ruleList.arrayReduction);
        arrayInstructions.addInstruction(86, elementSize);
        Pair.PairOfInstructionLists pair = new Pair.PairOfInstructionLists(arrayInstructions, (InstructionList)ruleList.closureReduction);
        this.generateABC(pair);
        return pair;
    }

    private void generateABC(Pair.PairOfInstructionLists pair) {
        assert (this.cinitInstructionList == null) : "generateABC should only be called once per reducer because each document should only be reduced once.";
        InstructionList initializeFactoryFunctions = this.cinitInstructionList = new InstructionList();
        if (this.styleTagIndex == 0) {
            initializeFactoryFunctions.addInstruction(208);
            initializeFactoryFunctions.addAll((InstructionList)pair.closureReduction);
            initializeFactoryFunctions.addInstruction(104, NAME_FACTORY_FUNCTIONS);
            initializeFactoryFunctions.addInstruction(208);
            initializeFactoryFunctions.addAll((InstructionList)pair.arrayReduction);
            initializeFactoryFunctions.addInstruction(104, NAME_DATA_ARRAY);
            initializeFactoryFunctions.addInstruction(208);
            for (String fontFace : this.fontFaces) {
                initializeFactoryFunctions.addInstruction(44, fontFace);
            }
            if (this.fontFaces.size() > 0) {
                initializeFactoryFunctions.addInstruction(86, this.fontFaces.size());
            } else {
                initializeFactoryFunctions.addInstruction(32);
            }
            initializeFactoryFunctions.addInstruction(104, NAME_FONTFACE_ARRAY);
            String inheritingStylesText = Joiner.on((String)",").skipNulls().join(this.session.inheritingStyles);
            initializeFactoryFunctions.addInstruction(208);
            initializeFactoryFunctions.addInstruction(32);
            initializeFactoryFunctions.addInstruction(104, NAME_INHERITING_STYLES);
        } else {
            initializeFactoryFunctions.addInstruction(208);
            initializeFactoryFunctions.addAll((InstructionList)pair.closureReduction);
            initializeFactoryFunctions.addInstruction(104, new Name(FACTORY_FUNCTIONS + Integer.toString(this.styleTagIndex)));
            initializeFactoryFunctions.addInstruction(208);
            initializeFactoryFunctions.addAll((InstructionList)pair.arrayReduction);
            initializeFactoryFunctions.addInstruction(104, new Name(DATA_ARRAY + Integer.toString(this.styleTagIndex)));
            initializeFactoryFunctions.addInstruction(208);
            for (String fontFace : this.fontFaces) {
                initializeFactoryFunctions.addInstruction(44, fontFace);
            }
            if (this.fontFaces.size() > 0) {
                initializeFactoryFunctions.addInstruction(86, this.fontFaces.size());
            } else {
                initializeFactoryFunctions.addInstruction(32);
            }
            initializeFactoryFunctions.addInstruction(104, new Name(FONTFACE_ARRAY + Integer.toString(this.styleTagIndex)));
            String inheritingStylesText = Joiner.on((String)",").skipNulls().join(this.session.inheritingStyles);
            initializeFactoryFunctions.addInstruction(208);
            initializeFactoryFunctions.addInstruction(32);
            initializeFactoryFunctions.addInstruction(104, new Name(INHERITING_STYLES + Integer.toString(this.styleTagIndex)));
        }
    }

    @Override
    public InstructionList getClassInitializationInstructions() {
        assert (this.cinitInstructionList != null) : "The initialize instructions may not be accessed until the document reduction has executed";
        return this.cinitInstructionList;
    }

    @Override
    public void visitClassTraits(ITraitsVisitor classTraitsVisitor) {
        IResolvedQualifiersReference referenceObject = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), "Object");
        IResolvedQualifiersReference referenceString = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), "String");
        IResolvedQualifiersReference referenceArray = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), "Array");
        classTraitsVisitor.visitSlotTrait(6, NAME_FACTORY_FUNCTIONS, 0, referenceObject.getMName(), LexicalScope.noInitializer);
        classTraitsVisitor.visitSlotTrait(6, NAME_DATA_ARRAY, 0, referenceArray.getMName(), LexicalScope.noInitializer);
        classTraitsVisitor.visitSlotTrait(0, NAME_INHERITING_STYLES, 0, referenceArray.getMName(), LexicalScope.noInitializer);
    }

    public Pair.PairOfInstructionLists reduceNamespaceDefinition(ICSSNode site) {
        return null;
    }

    public Pair.PairOfInstructionLists reduceNamespaceList(ICSSNode site, List<Pair.PairOfInstructionLists> namespaces) {
        return null;
    }

    public Pair.PairOfInstructionLists reduceProperty(ICSSNode site) {
        assert (site instanceof ICSSProperty) : "Expected ICSSProperty node but got " + site.getClass().getName();
        ICSSProperty propertyNode = (ICSSProperty)site;
        String name = propertyNode.getName();
        ICSSPropertyValue value = propertyNode.getValue();
        InstructionList inst = new InstructionList();
        InstructionList valueInstructions = this.getInstructionListForPropertyValue(value);
        if (!valueInstructions.isEmpty()) {
            inst.addInstruction(208);
            inst.addAll(valueInstructions);
            inst.addInstruction(97, new Name(name));
        }
        return new Pair.PairOfInstructionLists(new InstructionList(), inst);
    }

    /*
     * Enabled aggressive block sorting
     */
    private InstructionList getInstructionListForPropertyValue(ICSSPropertyValue value) {
        InstructionList valueInstructions = new InstructionList();
        if (value instanceof CSSStringPropertyValue) {
            valueInstructions.addInstruction(44, ((CSSStringPropertyValue)value).getValue());
            return valueInstructions;
        }
        if (value instanceof CSSColorPropertyValue) {
            valueInstructions.addInstruction(45, new Integer(((CSSColorPropertyValue)value).getColorAsInt()));
            return valueInstructions;
        }
        if (value instanceof CSSRgbColorPropertyValue) {
            valueInstructions.addInstruction(45, new Integer(((CSSRgbColorPropertyValue)value).getColorAsInt()));
            return valueInstructions;
        }
        if (value instanceof CSSRgbaColorPropertyValue) {
            valueInstructions.addInstruction(46, new Long(((CSSRgbaColorPropertyValue)value).getColorAsLong()));
            return valueInstructions;
        }
        if (value instanceof CSSKeywordPropertyValue) {
            CSSKeywordPropertyValue keywordValue = (CSSKeywordPropertyValue)value;
            String keywordString = keywordValue.getKeyword();
            if ("true".equals(keywordString)) {
                valueInstructions.addInstruction(38);
                return valueInstructions;
            }
            if ("false".equals(keywordString)) {
                valueInstructions.addInstruction(39);
                return valueInstructions;
            }
            valueInstructions.addInstruction(44, ((CSSKeywordPropertyValue)value).getKeyword());
            return valueInstructions;
        }
        if (value instanceof CSSNumberPropertyValue) {
            CSSNumberPropertyValue numValue = (CSSNumberPropertyValue)value;
            if (numValue.getUnit().equals("%")) {
                valueInstructions.addInstruction(44, numValue.toString());
                return valueInstructions;
            }
            valueInstructions.addInstruction(47, new Double(numValue.getNumber().doubleValue()));
            return valueInstructions;
        }
        if (value instanceof CSSFunctionCallPropertyValue) {
            CSSFunctionCallPropertyValue functionCall = (CSSFunctionCallPropertyValue)value;
            if ("ClassReference".equals(functionCall.name)) {
                String className = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw(functionCall.rawArguments);
                if ("null".equals(className)) {
                    valueInstructions.addInstruction(32);
                    return valueInstructions;
                }
                IResolvedQualifiersReference reference = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), className);
                valueInstructions.addInstruction(96, reference.getMName());
                return valueInstructions;
            }
            if ("url".equals(functionCall.name)) {
                String urlString = CSSFunctionCallPropertyValue.getSingleArgumentFromRaw(functionCall.rawArguments);
                valueInstructions.addInstruction(44, urlString);
                return valueInstructions;
            }
            if ("PropertyReference".equals(functionCall.name)) {
                return valueInstructions;
            }
            if ("Embed".equals(functionCall.name)) {
                EmbedCompilationUnit embedCompilationUnit = this.session.resolvedEmbedProperties.get(functionCall);
                if (embedCompilationUnit == null) {
                    CSSCodeGenProblem e = new CSSCodeGenProblem(new IllegalStateException("Unable to find compilation unit for " + functionCall));
                    this.problems.add(e);
                    return valueInstructions;
                }
                String qName = embedCompilationUnit.getName();
                IResolvedQualifiersReference reference = ReferenceFactory.packageQualifiedReference(this.project.getWorkspace(), qName);
                valueInstructions.addInstruction(96, reference.getMName());
                return valueInstructions;
            }
            if (this.project.isRoyale()) {
                valueInstructions.addInstruction(44, functionCall.toString());
                return valueInstructions;
            }
            if ($assertionsDisabled) throw new IllegalStateException("Unexpected function call property value: " + functionCall);
            throw new AssertionError((Object)("CSS parser bug: unexpected function call property value: " + functionCall));
        }
        if (value instanceof CSSArrayPropertyValue) {
            CSSArrayPropertyValue arrayValue = (CSSArrayPropertyValue)value;
            UnmodifiableIterator unmodifiableIterator = arrayValue.getElements().iterator();
            while (true) {
                if (!unmodifiableIterator.hasNext()) {
                    valueInstructions.addInstruction(86, arrayValue.getElements().size());
                    return valueInstructions;
                }
                ICSSPropertyValue elementValue = (ICSSPropertyValue)unmodifiableIterator.next();
                valueInstructions.addAll(this.getInstructionListForPropertyValue(elementValue));
            }
        }
        if (!(value instanceof CSSMultiValuePropertyValue)) {
            assert (false) : "Unsupported property value: " + value;
            return valueInstructions;
        }
        CSSMultiValuePropertyValue arrayValue = (CSSMultiValuePropertyValue)value;
        UnmodifiableIterator unmodifiableIterator = arrayValue.getElements().iterator();
        while (true) {
            if (!unmodifiableIterator.hasNext()) {
                valueInstructions.addInstruction(86, arrayValue.getElements().size());
                return valueInstructions;
            }
            ICSSPropertyValue elementValue = (ICSSPropertyValue)unmodifiableIterator.next();
            valueInstructions.addAll(this.getInstructionListForPropertyValue(elementValue));
        }
    }

    public Pair.PairOfInstructionLists reducePropertyList(ICSSNode site, List<Pair.PairOfInstructionLists> properties) {
        InstructionList closureInstructions = new InstructionList();
        for (Pair.PairOfInstructionLists inst : properties) {
            closureInstructions.addAll((InstructionList)inst.closureReduction);
        }
        closureInstructions.addInstruction(71);
        return new Pair.PairOfInstructionLists(null, closureInstructions);
    }

    public Pair.InstructionListAndClosure reduceRule(ICSSNode site, Pair.InstructionListAndClosure selector, Pair.PairOfInstructionLists propertyList) {
        MethodInfo methodInfo = new MethodInfo();
        String miName = ((ICSSSelector)((CSSRule)site).getSelectorGroup().get(0)).getElementName();
        if (this.mediaQueryString != null) {
            ArrayList<Object> factoryList;
            ABCGeneratingReducer.pushNumericConstant(ICSSRuntimeConstants.MEDIA_QUERY.intValue(), (InstructionList)selector.arrayReduction);
            ((InstructionList)selector.arrayReduction).addInstruction(44, this.mediaQueryString);
            miName = this.mediaQueryString + "_" + miName;
            if (this.mediaQueryMap.containsKey(this.mediaQueryString)) {
                factoryList = this.mediaQueryMap.get(this.mediaQueryString);
                factoryList.add(miName);
            } else {
                factoryList = new ArrayList<String>();
                factoryList.add(miName);
                this.mediaQueryMap.put(this.mediaQueryString, factoryList);
            }
        }
        methodInfo.setMethodName(miName);
        methodInfo.setParamTypes(EMPTY_PARAM_TYPES);
        IMethodVisitor methodVisitor = this.abcVisitor.visitMethod(methodInfo);
        methodVisitor.visit();
        MethodBodyInfo methodBodyInfo = new MethodBodyInfo();
        methodBodyInfo.setMethodInfo(methodInfo);
        IMethodBodyVisitor methodBodyVisitor = methodVisitor.visitBody(methodBodyInfo);
        methodBodyVisitor.visit();
        methodBodyVisitor.visitInstructionList((InstructionList)propertyList.closureReduction);
        methodBodyVisitor.visitEnd();
        methodVisitor.visitEnd();
        Set keySet = ((Map)selector.closureReduction).keySet();
        ArrayList keyList = new ArrayList();
        keyList.addAll(keySet);
        for (String name : keyList) {
            if (this.mediaQueryString != null) {
                ((Map)selector.closureReduction).remove(name);
                ((Map)selector.closureReduction).put(this.mediaQueryString + "_" + name, methodInfo);
                continue;
            }
            ((Map)selector.closureReduction).put(name, methodInfo);
        }
        this.mediaQueryString = null;
        return selector;
    }

    public Pair.InstructionListAndString reduceSelector(ICSSNode site) {
        assert (site instanceof ICSSSelector) : "Expected a 'selector' node, but got '" + site.getClass().getName() + "'.";
        InstructionList arrayInstructions = new InstructionList();
        ArrayList<String> resolvedSimpleSelectorNames = new ArrayList<String>();
        ICSSSelector selectorNode = (ICSSSelector)site;
        ImmutableList<ICSSSelector> selectors = CSSSelector.getCombinedSelectorList(selectorNode);
        for (ICSSSelector selector : selectors) {
            String selectorLiteral = this.getSelecterLiteralForABC(selector);
            for (ICSSSelectorCondition condition : selector.getConditions()) {
                ABCGeneratingReducer.pushNumericConstant(ICSSRuntimeConstants.CONDITION.intValue(), arrayInstructions);
                arrayInstructions.addInstruction(44, condition.getConditionType().name().toLowerCase());
                arrayInstructions.addInstruction(44, condition.getValue());
            }
            ABCGeneratingReducer.pushNumericConstant(ICSSRuntimeConstants.SELECTOR.intValue(), arrayInstructions);
            arrayInstructions.addInstruction(44, selectorLiteral);
            String resolvedSelectorName = selectorLiteral.concat(Joiner.on((String)"").join(selector.getConditions()));
            resolvedSimpleSelectorNames.add(resolvedSelectorName);
        }
        String combinedSelectors = Joiner.on((String)" ").join(resolvedSimpleSelectorNames);
        return new Pair.InstructionListAndString(arrayInstructions, combinedSelectors);
    }

    private String getSelecterLiteralForABC(ICSSSelector selector) {
        String selectorQname;
        if (this.project.getCSSManager().isFlex3CSS()) {
            assert (!selector.isAdvanced()) : "Advanced selector is not supported in Flex 3 mode. " + selector;
            String elementName = selector.getElementName();
            selectorQname = elementName == null ? "" : elementName;
        } else {
            String qname;
            selectorQname = CSSSemanticAnalyzer.isWildcardSelector(selector) ? (GLOBAL_SELECTOR.equals(selector.getElementName()) ? GLOBAL_SELECTOR : "") : ((qname = (String)this.resolvedSelectors.get((Object)selector)) == null ? selector.getElementName() : qname);
        }
        return selectorQname;
    }

    public Pair.PairOfInstructionLists reduceRuleList(ICSSNode site, List<Pair.InstructionListAndClosure> rules) {
        InstructionList arrayInstructions = new InstructionList();
        InstructionList closureInstructions = new InstructionList();
        int closureCount = 0;
        for (Pair.InstructionListAndClosure ruleReduction : rules) {
            arrayInstructions.addAll((InstructionList)ruleReduction.arrayReduction);
            for (Map.Entry entry : ((Map)ruleReduction.closureReduction).entrySet()) {
                closureInstructions.addInstruction(44, entry.getKey());
                closureInstructions.addInstruction(64, entry.getValue());
                ++closureCount;
            }
        }
        closureInstructions.addInstruction(85, closureCount);
        return new Pair.PairOfInstructionLists(arrayInstructions, closureInstructions);
    }

    public Pair.InstructionListAndClosure reduceSelectorGroup(ICSSNode site, List<Pair.InstructionListAndString> selectors) {
        InstructionList arrayInstructions = new InstructionList();
        HashMap<String, MethodInfo> closureNames = new HashMap<String, MethodInfo>();
        for (Pair.InstructionListAndString selectorReduction : selectors) {
            arrayInstructions.addAll((InstructionList)selectorReduction.arrayReduction);
            closureNames.put((String)selectorReduction.closureReduction, (MethodInfo)null);
        }
        ABCGeneratingReducer.pushNumericConstant(ICSSRuntimeConstants.STYLE_DECLARATION.intValue(), arrayInstructions);
        ABCGeneratingReducer.pushNumericConstant(this.factory.intValue(), arrayInstructions);
        return new Pair.InstructionListAndClosure(arrayInstructions, (Map<String, MethodInfo>)closureNames);
    }

    public Pair.PairOfInstructionLists reduceFontFaceList(ICSSNode site, List<Pair.PairOfInstructionLists> fontFaces) {
        return null;
    }

    public Pair.PairOfInstructionLists reduceFontFace(ICSSNode site) {
        CSSFontFace fontFace = (CSSFontFace)site;
        String fontFaceSource = fontFace.getSourceValue();
        this.fontFaces.add(fontFaceSource);
        return null;
    }

    public Pair.PairOfInstructionLists reduceMediaQuery(ICSSNode site, List<Pair.PairOfInstructionLists> conditions) {
        return null;
    }

    public Pair.PairOfInstructionLists reduceMediaQueryCondition(ICSSNode site) {
        this.mediaQueryString = this.mediaQueryString == null ? site.toString() : (this.mediaQueryString.endsWith("only") ? this.mediaQueryString + " " + site.toString() : (site.toString().equals(",") ? this.mediaQueryString + "," : (this.mediaQueryString.endsWith(",") ? this.mediaQueryString + " " + site.toString() : this.mediaQueryString + " and " + site.toString())));
        return null;
    }

    public Set<ICompilerProblem> getProblems() {
        return this.problems;
    }
}

