/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.rocketmq.streams.script.function.impl.math;

import org.apache.rocketmq.streams.common.context.IMessage;
import org.apache.rocketmq.streams.script.annotation.Function;
import org.apache.rocketmq.streams.script.annotation.FunctionMethod;
import org.apache.rocketmq.streams.script.annotation.FunctionParamter;
import org.apache.rocketmq.streams.script.context.FunctionContext;
import org.apache.rocketmq.streams.script.utils.FunctionUtils;

@Function
public class CbrtFunction {

    /**
     * 返回立方根
     *
     * @param message
     * @param context
     * @return
     */
    @FunctionMethod(value = "cbrt", alias = "cbrt", comment = "返回立方根")
    public Double cbrt(IMessage message, FunctionContext context,
                       @FunctionParamter(value = "Integer", comment = "待求值的常量") Integer number) {
        Double result = null;
        if (number == null || number < 0 || number > 20) {
            return result;
        }
        result = Math.cbrt(number);
        return result;
    }

    /**
     * 返回立方根
     *
     * @param message
     * @param context
     * @return
     */
    @FunctionMethod(value = "cbrt", alias = "cbrt", comment = "返回立方根")
    public Double cbrt(IMessage message, FunctionContext context,
                       @FunctionParamter(value = "String", comment = "待求值的字段名或常量") String number) {
        Double result = null;
        Integer numberTem = Integer.parseInt(FunctionUtils.getValueString(message, context, number));
        if (number == null || numberTem < 0 || numberTem > 20) {
            return result;
        }
        result = Math.cbrt(numberTem);
        return result;
    }
}