/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.hessian.generic.io;

import com.alipay.hessian.generic.io.AbstractGenericSerializerFactory;
import com.alipay.hessian.generic.io.GenericArraySerializer;
import com.alipay.hessian.generic.io.GenericClassDeserializer;
import com.alipay.hessian.generic.io.GenericClassSerializer;
import com.alipay.hessian.generic.io.GenericCollectionSerializer;
import com.alipay.hessian.generic.io.GenericDeserializer;
import com.alipay.hessian.generic.io.GenericMapSerializer;
import com.alipay.hessian.generic.io.GenericObjectSerializer;
import com.alipay.hessian.generic.model.GenericArray;
import com.alipay.hessian.generic.model.GenericClass;
import com.alipay.hessian.generic.model.GenericCollection;
import com.alipay.hessian.generic.model.GenericMap;
import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.hessian.generic.util.ClassFilter;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class GenericSerializerFactory
extends SerializerFactory {
    private static final ConcurrentMap<String, Deserializer> deserializerMap = new ConcurrentHashMap<String, Deserializer>();
    private static final char ARRAY_PREFIX = '[';
    private List<AbstractGenericSerializerFactory> factories = new CopyOnWriteArrayList<AbstractGenericSerializerFactory>();

    public void addGenericFactory(AbstractGenericSerializerFactory factory) {
        this.factories.add(factory);
        super.addFactory(factory);
    }

    @Override
    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (GenericObject.class == cl) {
            return GenericObjectSerializer.getInstance();
        }
        if (GenericArray.class == cl || GenericObject[].class == cl) {
            return GenericArraySerializer.getInstance();
        }
        if (GenericCollection.class == cl) {
            return GenericCollectionSerializer.getInstance();
        }
        if (GenericMap.class == cl) {
            return GenericMapSerializer.getInstance();
        }
        if (GenericClass.class == cl) {
            return GenericClassSerializer.getInstance();
        }
        return super.getSerializer(cl);
    }

    @Override
    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        return new JavaSerializer(cl);
    }

    @Override
    public Deserializer getDeserializer(String type) throws HessianProtocolException {
        if (this.isBlank(type) || ClassFilter.filterExcludeClass(type)) {
            return super.getDeserializer(type);
        }
        if (type.charAt(0) == '[' && ClassFilter.arrayFilter(type)) {
            return super.getDeserializer(type);
        }
        Deserializer deserializer = (Deserializer)deserializerMap.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        for (AbstractGenericSerializerFactory factory : this.factories) {
            deserializer = factory.getDeserializer(type);
            if (deserializer == null) continue;
            deserializerMap.put(type, deserializer);
            return deserializer;
        }
        deserializer = ClassFilter.CLASS_NAME.equals(type) ? GenericClassDeserializer.getInstance() : new GenericDeserializer(type);
        deserializerMap.put(type, deserializer);
        return deserializer;
    }

    private boolean isBlank(String str) {
        return str == null || str.length() == 0;
    }
}

