/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.processor;

import io.netty.channel.ChannelHandlerContext;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.constant.PermName;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.producer.RecallMessageHandle;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.RecallMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.RecallMessageResponseHeader;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.timer.TimerMessageStore;

public class RecallMessageProcessor
implements NettyRequestProcessor {
    private static final String RECALL_MESSAGE_TAG = "_RECALL_TAG_";
    private final BrokerController brokerController;

    public RecallMessageProcessor(BrokerController brokerController) {
        this.brokerController = brokerController;
    }

    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RecallMessageHandle.HandleV1 handle;
        RemotingCommand response = RemotingCommand.createResponseCommand(RecallMessageResponseHeader.class);
        response.addExtField("MSG_REGION", this.brokerController.getBrokerConfig().getRegionId());
        RecallMessageRequestHeader requestHeader = (RecallMessageRequestHeader)request.decodeCommandCustomHeader(RecallMessageRequestHeader.class);
        if (!this.brokerController.getBrokerConfig().isRecallMessageEnable()) {
            response.setCode(16);
            response.setRemark("recall failed, operation is forbidden");
            return response;
        }
        if (BrokerRole.SLAVE == this.brokerController.getMessageStoreConfig().getBrokerRole()) {
            response.setCode(11);
            response.setRemark("recall failed, broker service not available");
            return response;
        }
        long startTimestamp = this.brokerController.getBrokerConfig().getStartAcceptSendRequestTimeStamp();
        if (this.brokerController.getMessageStore().now() < startTimestamp) {
            response.setCode(14);
            response.setRemark("recall failed, broker service not available");
            return response;
        }
        if (!PermName.isWriteable((int)this.brokerController.getBrokerConfig().getBrokerPermission()) && !this.brokerController.getBrokerConfig().isAllowRecallWhenBrokerNotWriteable()) {
            response.setCode(14);
            response.setRemark("recall failed, broker service not available");
            return response;
        }
        TopicConfig topicConfig = this.brokerController.getTopicConfigManager().selectTopicConfig(requestHeader.getTopic());
        if (null == topicConfig) {
            response.setCode(17);
            response.setRemark("recall failed, the topic[" + requestHeader.getTopic() + "] not exist");
            return response;
        }
        try {
            handle = (RecallMessageHandle.HandleV1)RecallMessageHandle.decodeHandle((String)requestHeader.getRecallHandle());
        }
        catch (DecoderException e) {
            response.setCode(604);
            response.setRemark(e.getMessage());
            return response;
        }
        if (!requestHeader.getTopic().equals(handle.getTopic())) {
            response.setCode(604);
            response.setRemark("recall failed, topic not match");
            return response;
        }
        if (!this.brokerController.getBrokerConfig().getBrokerName().equals(handle.getBrokerName())) {
            response.setCode(604);
            response.setRemark("recall failed, broker service not available");
            return response;
        }
        long timestamp = NumberUtils.toLong((String)handle.getTimestampStr(), (long)-1L);
        long timeLeft = timestamp - System.currentTimeMillis();
        if (timeLeft <= 0L || timeLeft >= (long)this.brokerController.getMessageStoreConfig().getTimerMaxDelaySec() * 1000L) {
            response.setCode(604);
            response.setRemark("recall failed, timestamp invalid");
            return response;
        }
        MessageExtBrokerInner msgInner = this.buildMessage(ctx, requestHeader, handle);
        long beginTimeMillis = this.brokerController.getMessageStore().now();
        PutMessageResult putMessageResult = this.brokerController.getMessageStore().putMessage(msgInner);
        this.handlePutMessageResult(putMessageResult, request, response, (MessageExt)msgInner, ctx, beginTimeMillis);
        return response;
    }

    public MessageExtBrokerInner buildMessage(ChannelHandlerContext ctx, RecallMessageRequestHeader requestHeader, RecallMessageHandle.HandleV1 handle) {
        MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
        msgInner.setTopic(handle.getTopic());
        msgInner.setBody("0".getBytes(StandardCharsets.UTF_8));
        msgInner.setTags(RECALL_MESSAGE_TAG);
        msgInner.setTagsCode((long)RECALL_MESSAGE_TAG.hashCode());
        msgInner.setQueueId(0);
        MessageAccessor.putProperty((Message)msgInner, (String)"TIMER_DEL_UNIQKEY", (String)TimerMessageStore.buildDeleteKey((String)handle.getTopic(), (String)handle.getMessageId()));
        MessageAccessor.putProperty((Message)msgInner, (String)"UNIQ_KEY", (String)handle.getMessageId());
        MessageAccessor.putProperty((Message)msgInner, (String)"TIMER_DELIVER_MS", (String)String.valueOf(handle.getTimestampStr()));
        MessageAccessor.putProperty((Message)msgInner, (String)"BORN_TIMESTAMP", (String)String.valueOf(System.currentTimeMillis()));
        MessageAccessor.putProperty((Message)msgInner, (String)"TRACE_CONTEXT", (String)"");
        MessageAccessor.putProperty((Message)msgInner, (String)"PGROUP", (String)requestHeader.getProducerGroup());
        msgInner.setBornTimestamp(System.currentTimeMillis());
        msgInner.setPropertiesString(MessageDecoder.messageProperties2String((Map)msgInner.getProperties()));
        msgInner.setBornHost(ctx.channel().remoteAddress());
        msgInner.setStoreHost((SocketAddress)this.brokerController.getStoreHost());
        return msgInner;
    }

    public void handlePutMessageResult(PutMessageResult putMessageResult, RemotingCommand request, RemotingCommand response, MessageExt message, ChannelHandlerContext ctx, long beginTimeMillis) {
        if (null == putMessageResult) {
            response.setCode(1);
            response.setRemark("recall failed, execute error");
            return;
        }
        RecallMessageResponseHeader responseHeader = (RecallMessageResponseHeader)response.readCustomHeader();
        switch (putMessageResult.getPutMessageStatus()) {
            case PUT_OK: {
                this.brokerController.getBrokerStatsManager().incTopicPutNums(message.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
                this.brokerController.getBrokerStatsManager().incTopicPutSize(message.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
                this.brokerController.getBrokerStatsManager().incBrokerPutNums(message.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum());
                this.brokerController.getBrokerStatsManager().incTopicPutLatency(message.getTopic(), 0, (int)(this.brokerController.getMessageStore().now() - beginTimeMillis));
            }
            case FLUSH_DISK_TIMEOUT: 
            case FLUSH_SLAVE_TIMEOUT: 
            case SLAVE_NOT_AVAILABLE: {
                response.setCode(0);
                responseHeader.setMsgId(MessageClientIDSetter.getUniqID((Message)message));
                break;
            }
            default: {
                response.setCode(1);
                response.setRemark("recall failed, execute error");
            }
        }
    }

    public boolean rejectRequest() {
        return false;
    }
}

