/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SetTriggeringRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 775;
  }

  // Properties.
  protected final RequestHeader requestHeader;
  protected final long subscriptionId;
  protected final long triggeringItemId;
  protected final List<Long> linksToAdd;
  protected final List<Long> linksToRemove;

  public SetTriggeringRequest(
      RequestHeader requestHeader,
      long subscriptionId,
      long triggeringItemId,
      List<Long> linksToAdd,
      List<Long> linksToRemove) {
    super();
    this.requestHeader = requestHeader;
    this.subscriptionId = subscriptionId;
    this.triggeringItemId = triggeringItemId;
    this.linksToAdd = linksToAdd;
    this.linksToRemove = linksToRemove;
  }

  public RequestHeader getRequestHeader() {
    return requestHeader;
  }

  public long getSubscriptionId() {
    return subscriptionId;
  }

  public long getTriggeringItemId() {
    return triggeringItemId;
  }

  public List<Long> getLinksToAdd() {
    return linksToAdd;
  }

  public List<Long> getLinksToRemove() {
    return linksToRemove;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SetTriggeringRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, writeComplex(writeBuffer));

    // Simple Field (subscriptionId)
    writeSimpleField("subscriptionId", subscriptionId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (triggeringItemId)
    writeSimpleField("triggeringItemId", triggeringItemId, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfLinksToAdd) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfLinksToAdd = (int) ((((getLinksToAdd()) == (null)) ? -(1) : COUNT(getLinksToAdd())));
    writeImplicitField("noOfLinksToAdd", noOfLinksToAdd, writeSignedInt(writeBuffer, 32));

    // Array Field (linksToAdd)
    writeSimpleTypeArrayField("linksToAdd", linksToAdd, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfLinksToRemove) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfLinksToRemove =
        (int) ((((getLinksToRemove()) == (null)) ? -(1) : COUNT(getLinksToRemove())));
    writeImplicitField("noOfLinksToRemove", noOfLinksToRemove, writeSignedInt(writeBuffer, 32));

    // Array Field (linksToRemove)
    writeSimpleTypeArrayField("linksToRemove", linksToRemove, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("SetTriggeringRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SetTriggeringRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (subscriptionId)
    lengthInBits += 32;

    // Simple field (triggeringItemId)
    lengthInBits += 32;

    // Implicit Field (noOfLinksToAdd)
    lengthInBits += 32;

    // Array field
    if (linksToAdd != null) {
      lengthInBits += 32 * linksToAdd.size();
    }

    // Implicit Field (noOfLinksToRemove)
    lengthInBits += 32;

    // Array field
    if (linksToRemove != null) {
      lengthInBits += 32 * linksToRemove.size();
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("SetTriggeringRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestHeader requestHeader =
        readSimpleField(
            "requestHeader",
            readComplex(
                () ->
                    (RequestHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (391)),
                readBuffer));

    long subscriptionId = readSimpleField("subscriptionId", readUnsignedLong(readBuffer, 32));

    long triggeringItemId = readSimpleField("triggeringItemId", readUnsignedLong(readBuffer, 32));

    int noOfLinksToAdd = readImplicitField("noOfLinksToAdd", readSignedInt(readBuffer, 32));

    List<Long> linksToAdd =
        readCountArrayField("linksToAdd", readUnsignedLong(readBuffer, 32), noOfLinksToAdd);

    int noOfLinksToRemove = readImplicitField("noOfLinksToRemove", readSignedInt(readBuffer, 32));

    List<Long> linksToRemove =
        readCountArrayField("linksToRemove", readUnsignedLong(readBuffer, 32), noOfLinksToRemove);

    readBuffer.closeContext("SetTriggeringRequest");
    // Create the instance
    return new SetTriggeringRequestBuilderImpl(
        requestHeader, subscriptionId, triggeringItemId, linksToAdd, linksToRemove);
  }

  public static class SetTriggeringRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final RequestHeader requestHeader;
    private final long subscriptionId;
    private final long triggeringItemId;
    private final List<Long> linksToAdd;
    private final List<Long> linksToRemove;

    public SetTriggeringRequestBuilderImpl(
        RequestHeader requestHeader,
        long subscriptionId,
        long triggeringItemId,
        List<Long> linksToAdd,
        List<Long> linksToRemove) {
      this.requestHeader = requestHeader;
      this.subscriptionId = subscriptionId;
      this.triggeringItemId = triggeringItemId;
      this.linksToAdd = linksToAdd;
      this.linksToRemove = linksToRemove;
    }

    public SetTriggeringRequest build() {
      SetTriggeringRequest setTriggeringRequest =
          new SetTriggeringRequest(
              requestHeader, subscriptionId, triggeringItemId, linksToAdd, linksToRemove);
      return setTriggeringRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SetTriggeringRequest)) {
      return false;
    }
    SetTriggeringRequest that = (SetTriggeringRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getSubscriptionId() == that.getSubscriptionId())
        && (getTriggeringItemId() == that.getTriggeringItemId())
        && (getLinksToAdd() == that.getLinksToAdd())
        && (getLinksToRemove() == that.getLinksToRemove())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getSubscriptionId(),
        getTriggeringItemId(),
        getLinksToAdd(),
        getLinksToRemove());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
