/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class GuidValue implements Message {

  // Properties.
  protected final long data1;
  protected final int data2;
  protected final int data3;
  protected final byte[] data4;
  protected final byte[] data5;

  public GuidValue(long data1, int data2, int data3, byte[] data4, byte[] data5) {
    super();
    this.data1 = data1;
    this.data2 = data2;
    this.data3 = data3;
    this.data4 = data4;
    this.data5 = data5;
  }

  public long getData1() {
    return data1;
  }

  public int getData2() {
    return data2;
  }

  public int getData3() {
    return data3;
  }

  public byte[] getData4() {
    return data4;
  }

  public byte[] getData5() {
    return data5;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("GuidValue");

    // Simple Field (data1)
    writeSimpleField("data1", data1, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (data2)
    writeSimpleField("data2", data2, writeUnsignedInt(writeBuffer, 16));

    // Simple Field (data3)
    writeSimpleField("data3", data3, writeUnsignedInt(writeBuffer, 16));

    // Array Field (data4)
    writeByteArrayField("data4", data4, writeByteArray(writeBuffer, 8));

    // Array Field (data5)
    writeByteArrayField("data5", data5, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("GuidValue");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    GuidValue _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (data1)
    lengthInBits += 32;

    // Simple field (data2)
    lengthInBits += 16;

    // Simple field (data3)
    lengthInBits += 16;

    // Array field
    if (data4 != null) {
      lengthInBits += 8 * data4.length;
    }

    // Array field
    if (data5 != null) {
      lengthInBits += 8 * data5.length;
    }

    return lengthInBits;
  }

  public static GuidValue staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("GuidValue");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long data1 = readSimpleField("data1", readUnsignedLong(readBuffer, 32));

    int data2 = readSimpleField("data2", readUnsignedInt(readBuffer, 16));

    int data3 = readSimpleField("data3", readUnsignedInt(readBuffer, 16));

    byte[] data4 = readBuffer.readByteArray("data4", Math.toIntExact(2));

    byte[] data5 = readBuffer.readByteArray("data5", Math.toIntExact(6));

    readBuffer.closeContext("GuidValue");
    // Create the instance
    GuidValue _guidValue;
    _guidValue = new GuidValue(data1, data2, data3, data4, data5);
    return _guidValue;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof GuidValue)) {
      return false;
    }
    GuidValue that = (GuidValue) o;
    return (getData1() == that.getData1())
        && (getData2() == that.getData2())
        && (getData3() == that.getData3())
        && (getData4() == that.getData4())
        && (getData5() == that.getData5())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getData1(), getData2(), getData3(), getData4(), getData5());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
