/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class WritePropertyMultipleError extends BACnetError implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getErrorChoice() {
    return BACnetConfirmedServiceChoice.WRITE_PROPERTY_MULTIPLE;
  }

  // Properties.
  protected final ErrorEnclosed errorType;
  protected final BACnetObjectPropertyReferenceEnclosed firstFailedWriteAttempt;

  public WritePropertyMultipleError(
      ErrorEnclosed errorType, BACnetObjectPropertyReferenceEnclosed firstFailedWriteAttempt) {
    super();
    this.errorType = errorType;
    this.firstFailedWriteAttempt = firstFailedWriteAttempt;
  }

  public ErrorEnclosed getErrorType() {
    return errorType;
  }

  public BACnetObjectPropertyReferenceEnclosed getFirstFailedWriteAttempt() {
    return firstFailedWriteAttempt;
  }

  @Override
  protected void serializeBACnetErrorChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("WritePropertyMultipleError");

    // Simple Field (errorType)
    writeSimpleField("errorType", errorType, writeComplex(writeBuffer));

    // Simple Field (firstFailedWriteAttempt)
    writeSimpleField("firstFailedWriteAttempt", firstFailedWriteAttempt, writeComplex(writeBuffer));

    writeBuffer.popContext("WritePropertyMultipleError");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    WritePropertyMultipleError _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (errorType)
    lengthInBits += errorType.getLengthInBits();

    // Simple field (firstFailedWriteAttempt)
    lengthInBits += firstFailedWriteAttempt.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetErrorBuilder staticParseBACnetErrorBuilder(
      ReadBuffer readBuffer, BACnetConfirmedServiceChoice errorChoice) throws ParseException {
    readBuffer.pullContext("WritePropertyMultipleError");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ErrorEnclosed errorType =
        readSimpleField(
            "errorType",
            readComplex(() -> ErrorEnclosed.staticParse(readBuffer, (short) (0)), readBuffer));

    BACnetObjectPropertyReferenceEnclosed firstFailedWriteAttempt =
        readSimpleField(
            "firstFailedWriteAttempt",
            readComplex(
                () -> BACnetObjectPropertyReferenceEnclosed.staticParse(readBuffer, (short) (1)),
                readBuffer));

    readBuffer.closeContext("WritePropertyMultipleError");
    // Create the instance
    return new WritePropertyMultipleErrorBuilderImpl(errorType, firstFailedWriteAttempt);
  }

  public static class WritePropertyMultipleErrorBuilderImpl
      implements BACnetError.BACnetErrorBuilder {
    private final ErrorEnclosed errorType;
    private final BACnetObjectPropertyReferenceEnclosed firstFailedWriteAttempt;

    public WritePropertyMultipleErrorBuilderImpl(
        ErrorEnclosed errorType, BACnetObjectPropertyReferenceEnclosed firstFailedWriteAttempt) {
      this.errorType = errorType;
      this.firstFailedWriteAttempt = firstFailedWriteAttempt;
    }

    public WritePropertyMultipleError build() {
      WritePropertyMultipleError writePropertyMultipleError =
          new WritePropertyMultipleError(errorType, firstFailedWriteAttempt);
      return writePropertyMultipleError;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof WritePropertyMultipleError)) {
      return false;
    }
    WritePropertyMultipleError that = (WritePropertyMultipleError) o;
    return (getErrorType() == that.getErrorType())
        && (getFirstFailedWriteAttempt() == that.getFirstFailedWriteAttempt())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getErrorType(), getFirstFailedWriteAttempt());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
