/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetNotificationParametersChangeOfTimer extends BACnetNotificationParameters
    implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final BACnetOpeningTag innerOpeningTag;
  protected final BACnetTimerStateTagged newValue;
  protected final BACnetStatusFlagsTagged statusFlags;
  protected final BACnetDateTimeEnclosed updateTime;
  protected final BACnetTimerTransitionTagged lastStateChange;
  protected final BACnetContextTagUnsignedInteger initialTimeout;
  protected final BACnetDateTimeEnclosed expirationTime;
  protected final BACnetClosingTag innerClosingTag;

  // Arguments.
  protected final Short tagNumber;
  protected final BACnetObjectType objectTypeArgument;

  public BACnetNotificationParametersChangeOfTimer(
      BACnetOpeningTag openingTag,
      BACnetTagHeader peekedTagHeader,
      BACnetClosingTag closingTag,
      BACnetOpeningTag innerOpeningTag,
      BACnetTimerStateTagged newValue,
      BACnetStatusFlagsTagged statusFlags,
      BACnetDateTimeEnclosed updateTime,
      BACnetTimerTransitionTagged lastStateChange,
      BACnetContextTagUnsignedInteger initialTimeout,
      BACnetDateTimeEnclosed expirationTime,
      BACnetClosingTag innerClosingTag,
      Short tagNumber,
      BACnetObjectType objectTypeArgument) {
    super(openingTag, peekedTagHeader, closingTag, tagNumber, objectTypeArgument);
    this.innerOpeningTag = innerOpeningTag;
    this.newValue = newValue;
    this.statusFlags = statusFlags;
    this.updateTime = updateTime;
    this.lastStateChange = lastStateChange;
    this.initialTimeout = initialTimeout;
    this.expirationTime = expirationTime;
    this.innerClosingTag = innerClosingTag;
    this.tagNumber = tagNumber;
    this.objectTypeArgument = objectTypeArgument;
  }

  public BACnetOpeningTag getInnerOpeningTag() {
    return innerOpeningTag;
  }

  public BACnetTimerStateTagged getNewValue() {
    return newValue;
  }

  public BACnetStatusFlagsTagged getStatusFlags() {
    return statusFlags;
  }

  public BACnetDateTimeEnclosed getUpdateTime() {
    return updateTime;
  }

  public BACnetTimerTransitionTagged getLastStateChange() {
    return lastStateChange;
  }

  public BACnetContextTagUnsignedInteger getInitialTimeout() {
    return initialTimeout;
  }

  public BACnetDateTimeEnclosed getExpirationTime() {
    return expirationTime;
  }

  public BACnetClosingTag getInnerClosingTag() {
    return innerClosingTag;
  }

  @Override
  protected void serializeBACnetNotificationParametersChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetNotificationParametersChangeOfTimer");

    // Simple Field (innerOpeningTag)
    writeSimpleField("innerOpeningTag", innerOpeningTag, writeComplex(writeBuffer));

    // Simple Field (newValue)
    writeSimpleField("newValue", newValue, writeComplex(writeBuffer));

    // Simple Field (statusFlags)
    writeSimpleField("statusFlags", statusFlags, writeComplex(writeBuffer));

    // Simple Field (updateTime)
    writeSimpleField("updateTime", updateTime, writeComplex(writeBuffer));

    // Optional Field (lastStateChange) (Can be skipped, if the value is null)
    writeOptionalField("lastStateChange", lastStateChange, writeComplex(writeBuffer));

    // Optional Field (initialTimeout) (Can be skipped, if the value is null)
    writeOptionalField("initialTimeout", initialTimeout, writeComplex(writeBuffer));

    // Optional Field (expirationTime) (Can be skipped, if the value is null)
    writeOptionalField("expirationTime", expirationTime, writeComplex(writeBuffer));

    // Simple Field (innerClosingTag)
    writeSimpleField("innerClosingTag", innerClosingTag, writeComplex(writeBuffer));

    writeBuffer.popContext("BACnetNotificationParametersChangeOfTimer");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetNotificationParametersChangeOfTimer _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (innerOpeningTag)
    lengthInBits += innerOpeningTag.getLengthInBits();

    // Simple field (newValue)
    lengthInBits += newValue.getLengthInBits();

    // Simple field (statusFlags)
    lengthInBits += statusFlags.getLengthInBits();

    // Simple field (updateTime)
    lengthInBits += updateTime.getLengthInBits();

    // Optional Field (lastStateChange)
    if (lastStateChange != null) {
      lengthInBits += lastStateChange.getLengthInBits();
    }

    // Optional Field (initialTimeout)
    if (initialTimeout != null) {
      lengthInBits += initialTimeout.getLengthInBits();
    }

    // Optional Field (expirationTime)
    if (expirationTime != null) {
      lengthInBits += expirationTime.getLengthInBits();
    }

    // Simple field (innerClosingTag)
    lengthInBits += innerClosingTag.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetNotificationParametersBuilder staticParseBACnetNotificationParametersBuilder(
      ReadBuffer readBuffer,
      Short peekedTagNumber,
      Short tagNumber,
      BACnetObjectType objectTypeArgument)
      throws ParseException {
    readBuffer.pullContext("BACnetNotificationParametersChangeOfTimer");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetOpeningTag innerOpeningTag =
        readSimpleField(
            "innerOpeningTag",
            readComplex(
                () -> BACnetOpeningTag.staticParse(readBuffer, (short) (peekedTagNumber)),
                readBuffer));

    BACnetTimerStateTagged newValue =
        readSimpleField(
            "newValue",
            readComplex(
                () ->
                    BACnetTimerStateTagged.staticParse(
                        readBuffer, (short) (0), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetStatusFlagsTagged statusFlags =
        readSimpleField(
            "statusFlags",
            readComplex(
                () ->
                    BACnetStatusFlagsTagged.staticParse(
                        readBuffer, (short) (1), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetDateTimeEnclosed updateTime =
        readSimpleField(
            "updateTime",
            readComplex(
                () -> BACnetDateTimeEnclosed.staticParse(readBuffer, (short) (2)), readBuffer));

    BACnetTimerTransitionTagged lastStateChange =
        readOptionalField(
            "lastStateChange",
            readComplex(
                () ->
                    BACnetTimerTransitionTagged.staticParse(
                        readBuffer, (short) (3), (TagClass) (TagClass.CONTEXT_SPECIFIC_TAGS)),
                readBuffer));

    BACnetContextTagUnsignedInteger initialTimeout =
        readOptionalField(
            "initialTimeout",
            readComplex(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (4),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetDateTimeEnclosed expirationTime =
        readOptionalField(
            "expirationTime",
            readComplex(
                () -> BACnetDateTimeEnclosed.staticParse(readBuffer, (short) (5)), readBuffer));

    BACnetClosingTag innerClosingTag =
        readSimpleField(
            "innerClosingTag",
            readComplex(
                () -> BACnetClosingTag.staticParse(readBuffer, (short) (peekedTagNumber)),
                readBuffer));

    readBuffer.closeContext("BACnetNotificationParametersChangeOfTimer");
    // Create the instance
    return new BACnetNotificationParametersChangeOfTimerBuilderImpl(
        innerOpeningTag,
        newValue,
        statusFlags,
        updateTime,
        lastStateChange,
        initialTimeout,
        expirationTime,
        innerClosingTag,
        tagNumber,
        objectTypeArgument);
  }

  public static class BACnetNotificationParametersChangeOfTimerBuilderImpl
      implements BACnetNotificationParameters.BACnetNotificationParametersBuilder {
    private final BACnetOpeningTag innerOpeningTag;
    private final BACnetTimerStateTagged newValue;
    private final BACnetStatusFlagsTagged statusFlags;
    private final BACnetDateTimeEnclosed updateTime;
    private final BACnetTimerTransitionTagged lastStateChange;
    private final BACnetContextTagUnsignedInteger initialTimeout;
    private final BACnetDateTimeEnclosed expirationTime;
    private final BACnetClosingTag innerClosingTag;
    private final Short tagNumber;
    private final BACnetObjectType objectTypeArgument;

    public BACnetNotificationParametersChangeOfTimerBuilderImpl(
        BACnetOpeningTag innerOpeningTag,
        BACnetTimerStateTagged newValue,
        BACnetStatusFlagsTagged statusFlags,
        BACnetDateTimeEnclosed updateTime,
        BACnetTimerTransitionTagged lastStateChange,
        BACnetContextTagUnsignedInteger initialTimeout,
        BACnetDateTimeEnclosed expirationTime,
        BACnetClosingTag innerClosingTag,
        Short tagNumber,
        BACnetObjectType objectTypeArgument) {
      this.innerOpeningTag = innerOpeningTag;
      this.newValue = newValue;
      this.statusFlags = statusFlags;
      this.updateTime = updateTime;
      this.lastStateChange = lastStateChange;
      this.initialTimeout = initialTimeout;
      this.expirationTime = expirationTime;
      this.innerClosingTag = innerClosingTag;
      this.tagNumber = tagNumber;
      this.objectTypeArgument = objectTypeArgument;
    }

    public BACnetNotificationParametersChangeOfTimer build(
        BACnetOpeningTag openingTag,
        BACnetTagHeader peekedTagHeader,
        BACnetClosingTag closingTag,
        Short tagNumber,
        BACnetObjectType objectTypeArgument) {
      BACnetNotificationParametersChangeOfTimer bACnetNotificationParametersChangeOfTimer =
          new BACnetNotificationParametersChangeOfTimer(
              openingTag,
              peekedTagHeader,
              closingTag,
              innerOpeningTag,
              newValue,
              statusFlags,
              updateTime,
              lastStateChange,
              initialTimeout,
              expirationTime,
              innerClosingTag,
              tagNumber,
              objectTypeArgument);
      return bACnetNotificationParametersChangeOfTimer;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetNotificationParametersChangeOfTimer)) {
      return false;
    }
    BACnetNotificationParametersChangeOfTimer that = (BACnetNotificationParametersChangeOfTimer) o;
    return (getInnerOpeningTag() == that.getInnerOpeningTag())
        && (getNewValue() == that.getNewValue())
        && (getStatusFlags() == that.getStatusFlags())
        && (getUpdateTime() == that.getUpdateTime())
        && (getLastStateChange() == that.getLastStateChange())
        && (getInitialTimeout() == that.getInitialTimeout())
        && (getExpirationTime() == that.getExpirationTime())
        && (getInnerClosingTag() == that.getInnerClosingTag())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getInnerOpeningTag(),
        getNewValue(),
        getStatusFlags(),
        getUpdateTime(),
        getLastStateChange(),
        getInitialTimeout(),
        getExpirationTime(),
        getInnerClosingTag());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
