/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableQuantity is an enum
type OpcuaNodeIdServicesVariableQuantity int32

type IOpcuaNodeIdServicesVariableQuantity interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableQuantity_QuantityType_Symbol                                                     OpcuaNodeIdServicesVariableQuantity = 32476
	OpcuaNodeIdServicesVariableQuantity_QuantityType_Annotation                                                 OpcuaNodeIdServicesVariableQuantity = 32478
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ConversionService                                          OpcuaNodeIdServicesVariableQuantity = 32479
	OpcuaNodeIdServicesVariableQuantity_QuantityType_Dimension                                                  OpcuaNodeIdServicesVariableQuantity = 32480
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol                  OpcuaNodeIdServicesVariableQuantity = 32483
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem              OpcuaNodeIdServicesVariableQuantity = 32485
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline              OpcuaNodeIdServicesVariableQuantity = 32486
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit         OpcuaNodeIdServicesVariableQuantity = 32496
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol     OpcuaNodeIdServicesVariableQuantity = 32498
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem OpcuaNodeIdServicesVariableQuantity = 32500
	OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline OpcuaNodeIdServicesVariableQuantity = 32501
)

var OpcuaNodeIdServicesVariableQuantityValues []OpcuaNodeIdServicesVariableQuantity

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableQuantityValues = []OpcuaNodeIdServicesVariableQuantity{
		OpcuaNodeIdServicesVariableQuantity_QuantityType_Symbol,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_Annotation,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ConversionService,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_Dimension,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem,
		OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline,
	}
}

func OpcuaNodeIdServicesVariableQuantityByValue(value int32) (enum OpcuaNodeIdServicesVariableQuantity, ok bool) {
	switch value {
	case 32476:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_Symbol, true
	case 32478:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_Annotation, true
	case 32479:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ConversionService, true
	case 32480:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_Dimension, true
	case 32483:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol, true
	case 32485:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem, true
	case 32486:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline, true
	case 32496:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit, true
	case 32498:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol, true
	case 32500:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem, true
	case 32501:
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableQuantityByName(value string) (enum OpcuaNodeIdServicesVariableQuantity, ok bool) {
	switch value {
	case "QuantityType_Symbol":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_Symbol, true
	case "QuantityType_Annotation":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_Annotation, true
	case "QuantityType_ConversionService":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ConversionService, true
	case "QuantityType_Dimension":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_Dimension, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem, true
	case "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline":
		return OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableQuantityKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableQuantityValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableQuantity(structType any) OpcuaNodeIdServicesVariableQuantity {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableQuantity {
		if sOpcuaNodeIdServicesVariableQuantity, ok := typ.(OpcuaNodeIdServicesVariableQuantity); ok {
			return sOpcuaNodeIdServicesVariableQuantity
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableQuantity) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableQuantity) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableQuantityParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableQuantity, error) {
	return OpcuaNodeIdServicesVariableQuantityParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableQuantityParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableQuantity, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableQuantity", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableQuantity")
	}
	if enum, ok := OpcuaNodeIdServicesVariableQuantityByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableQuantity")
		return OpcuaNodeIdServicesVariableQuantity(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableQuantity) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableQuantity) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableQuantity", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableQuantity) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableQuantity) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_Symbol:
		return "QuantityType_Symbol"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_Annotation:
		return "QuantityType_Annotation"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ConversionService:
		return "QuantityType_ConversionService"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_Dimension:
		return "QuantityType_Dimension"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_Symbol"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_UnitSystem"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_Discipline"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_ConversionLimit"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Symbol"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_UnitSystem"
	case OpcuaNodeIdServicesVariableQuantity_QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline:
		return "QuantityType_ServerUnits_ServerUnit_Placeholder_CoherentUnit_Discipline"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableQuantity) String() string {
	return e.PLC4XEnumName()
}
