/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BaseConfigurationRecordDataType is the corresponding interface of BaseConfigurationRecordDataType
type BaseConfigurationRecordDataType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	ExtensionObjectDefinition
	// GetName returns Name (property field)
	GetName() PascalString
	// GetRecordProperties returns RecordProperties (property field)
	GetRecordProperties() []KeyValuePair
	// IsBaseConfigurationRecordDataType is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBaseConfigurationRecordDataType()
	// CreateBuilder creates a BaseConfigurationRecordDataTypeBuilder
	CreateBaseConfigurationRecordDataTypeBuilder() BaseConfigurationRecordDataTypeBuilder
}

// _BaseConfigurationRecordDataType is the data-structure of this message
type _BaseConfigurationRecordDataType struct {
	ExtensionObjectDefinitionContract
	Name             PascalString
	RecordProperties []KeyValuePair
}

var _ BaseConfigurationRecordDataType = (*_BaseConfigurationRecordDataType)(nil)
var _ ExtensionObjectDefinitionRequirements = (*_BaseConfigurationRecordDataType)(nil)

// NewBaseConfigurationRecordDataType factory function for _BaseConfigurationRecordDataType
func NewBaseConfigurationRecordDataType(name PascalString, recordProperties []KeyValuePair) *_BaseConfigurationRecordDataType {
	if name == nil {
		panic("name of type PascalString for BaseConfigurationRecordDataType must not be nil")
	}
	_result := &_BaseConfigurationRecordDataType{
		ExtensionObjectDefinitionContract: NewExtensionObjectDefinition(),
		Name:                              name,
		RecordProperties:                  recordProperties,
	}
	_result.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BaseConfigurationRecordDataTypeBuilder is a builder for BaseConfigurationRecordDataType
type BaseConfigurationRecordDataTypeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(name PascalString, recordProperties []KeyValuePair) BaseConfigurationRecordDataTypeBuilder
	// WithName adds Name (property field)
	WithName(PascalString) BaseConfigurationRecordDataTypeBuilder
	// WithNameBuilder adds Name (property field) which is build by the builder
	WithNameBuilder(func(PascalStringBuilder) PascalStringBuilder) BaseConfigurationRecordDataTypeBuilder
	// WithRecordProperties adds RecordProperties (property field)
	WithRecordProperties(...KeyValuePair) BaseConfigurationRecordDataTypeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() ExtensionObjectDefinitionBuilder
	// Build builds the BaseConfigurationRecordDataType or returns an error if something is wrong
	Build() (BaseConfigurationRecordDataType, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BaseConfigurationRecordDataType
}

// NewBaseConfigurationRecordDataTypeBuilder() creates a BaseConfigurationRecordDataTypeBuilder
func NewBaseConfigurationRecordDataTypeBuilder() BaseConfigurationRecordDataTypeBuilder {
	return &_BaseConfigurationRecordDataTypeBuilder{_BaseConfigurationRecordDataType: new(_BaseConfigurationRecordDataType)}
}

type _BaseConfigurationRecordDataTypeBuilder struct {
	*_BaseConfigurationRecordDataType

	parentBuilder *_ExtensionObjectDefinitionBuilder

	collectedErr []error
}

var _ (BaseConfigurationRecordDataTypeBuilder) = (*_BaseConfigurationRecordDataTypeBuilder)(nil)

func (b *_BaseConfigurationRecordDataTypeBuilder) setParent(contract ExtensionObjectDefinitionContract) {
	b.ExtensionObjectDefinitionContract = contract
	contract.(*_ExtensionObjectDefinition)._SubType = b._BaseConfigurationRecordDataType
}

func (b *_BaseConfigurationRecordDataTypeBuilder) WithMandatoryFields(name PascalString, recordProperties []KeyValuePair) BaseConfigurationRecordDataTypeBuilder {
	return b.WithName(name).WithRecordProperties(recordProperties...)
}

func (b *_BaseConfigurationRecordDataTypeBuilder) WithName(name PascalString) BaseConfigurationRecordDataTypeBuilder {
	b.Name = name
	return b
}

func (b *_BaseConfigurationRecordDataTypeBuilder) WithNameBuilder(builderSupplier func(PascalStringBuilder) PascalStringBuilder) BaseConfigurationRecordDataTypeBuilder {
	builder := builderSupplier(b.Name.CreatePascalStringBuilder())
	var err error
	b.Name, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "PascalStringBuilder failed"))
	}
	return b
}

func (b *_BaseConfigurationRecordDataTypeBuilder) WithRecordProperties(recordProperties ...KeyValuePair) BaseConfigurationRecordDataTypeBuilder {
	b.RecordProperties = recordProperties
	return b
}

func (b *_BaseConfigurationRecordDataTypeBuilder) Build() (BaseConfigurationRecordDataType, error) {
	if b.Name == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'name' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BaseConfigurationRecordDataType.deepCopy(), nil
}

func (b *_BaseConfigurationRecordDataTypeBuilder) MustBuild() BaseConfigurationRecordDataType {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BaseConfigurationRecordDataTypeBuilder) Done() ExtensionObjectDefinitionBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewExtensionObjectDefinitionBuilder().(*_ExtensionObjectDefinitionBuilder)
	}
	return b.parentBuilder
}

func (b *_BaseConfigurationRecordDataTypeBuilder) buildForExtensionObjectDefinition() (ExtensionObjectDefinition, error) {
	return b.Build()
}

func (b *_BaseConfigurationRecordDataTypeBuilder) DeepCopy() any {
	_copy := b.CreateBaseConfigurationRecordDataTypeBuilder().(*_BaseConfigurationRecordDataTypeBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBaseConfigurationRecordDataTypeBuilder creates a BaseConfigurationRecordDataTypeBuilder
func (b *_BaseConfigurationRecordDataType) CreateBaseConfigurationRecordDataTypeBuilder() BaseConfigurationRecordDataTypeBuilder {
	if b == nil {
		return NewBaseConfigurationRecordDataTypeBuilder()
	}
	return &_BaseConfigurationRecordDataTypeBuilder{_BaseConfigurationRecordDataType: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BaseConfigurationRecordDataType) GetExtensionId() int32 {
	return int32(15437)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BaseConfigurationRecordDataType) GetParent() ExtensionObjectDefinitionContract {
	return m.ExtensionObjectDefinitionContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BaseConfigurationRecordDataType) GetName() PascalString {
	return m.Name
}

func (m *_BaseConfigurationRecordDataType) GetRecordProperties() []KeyValuePair {
	return m.RecordProperties
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBaseConfigurationRecordDataType(structType any) BaseConfigurationRecordDataType {
	if casted, ok := structType.(BaseConfigurationRecordDataType); ok {
		return casted
	}
	if casted, ok := structType.(*BaseConfigurationRecordDataType); ok {
		return *casted
	}
	return nil
}

func (m *_BaseConfigurationRecordDataType) GetTypeName() string {
	return "BaseConfigurationRecordDataType"
}

func (m *_BaseConfigurationRecordDataType) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).getLengthInBits(ctx))

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	// Implicit Field (noOfRecordProperties)
	lengthInBits += 32

	// Array field
	if len(m.RecordProperties) > 0 {
		for _curItem, element := range m.RecordProperties {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.RecordProperties), _curItem)
			lengthInBits += element.GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_BaseConfigurationRecordDataType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BaseConfigurationRecordDataType) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_ExtensionObjectDefinition, extensionId int32) (__baseConfigurationRecordDataType BaseConfigurationRecordDataType, err error) {
	m.ExtensionObjectDefinitionContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BaseConfigurationRecordDataType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BaseConfigurationRecordDataType")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	name, err := ReadSimpleField[PascalString](ctx, "name", ReadComplex[PascalString](PascalStringParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'name' field"))
	}
	m.Name = name

	noOfRecordProperties, err := ReadImplicitField[int32](ctx, "noOfRecordProperties", ReadSignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'noOfRecordProperties' field"))
	}
	_ = noOfRecordProperties

	recordProperties, err := ReadCountArrayField[KeyValuePair](ctx, "recordProperties", ReadComplex[KeyValuePair](ExtensionObjectDefinitionParseWithBufferProducer[KeyValuePair]((int32)(int32(14535))), readBuffer), uint64(noOfRecordProperties))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'recordProperties' field"))
	}
	m.RecordProperties = recordProperties

	if closeErr := readBuffer.CloseContext("BaseConfigurationRecordDataType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BaseConfigurationRecordDataType")
	}

	return m, nil
}

func (m *_BaseConfigurationRecordDataType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BaseConfigurationRecordDataType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BaseConfigurationRecordDataType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BaseConfigurationRecordDataType")
		}

		if err := WriteSimpleField[PascalString](ctx, "name", m.GetName(), WriteComplex[PascalString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'name' field")
		}
		noOfRecordProperties := int32(utils.InlineIf(bool((m.GetRecordProperties()) == (nil)), func() any { return int32(-(int32(1))) }, func() any { return int32(int32(len(m.GetRecordProperties()))) }).(int32))
		if err := WriteImplicitField(ctx, "noOfRecordProperties", noOfRecordProperties, WriteSignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'noOfRecordProperties' field")
		}

		if err := WriteComplexTypeArrayField(ctx, "recordProperties", m.GetRecordProperties(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'recordProperties' field")
		}

		if popErr := writeBuffer.PopContext("BaseConfigurationRecordDataType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BaseConfigurationRecordDataType")
		}
		return nil
	}
	return m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BaseConfigurationRecordDataType) IsBaseConfigurationRecordDataType() {}

func (m *_BaseConfigurationRecordDataType) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BaseConfigurationRecordDataType) deepCopy() *_BaseConfigurationRecordDataType {
	if m == nil {
		return nil
	}
	_BaseConfigurationRecordDataTypeCopy := &_BaseConfigurationRecordDataType{
		m.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition).deepCopy(),
		utils.DeepCopy[PascalString](m.Name),
		utils.DeepCopySlice[KeyValuePair, KeyValuePair](m.RecordProperties),
	}
	_BaseConfigurationRecordDataTypeCopy.ExtensionObjectDefinitionContract.(*_ExtensionObjectDefinition)._SubType = m
	return _BaseConfigurationRecordDataTypeCopy
}

func (m *_BaseConfigurationRecordDataType) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
