/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/pkg/errors"

	. "github.com/apache/plc4x/plc4go/protocols/cbus/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type CbusParserHelper struct {
}

func (m CbusParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "HVACStatusFlags":
		return HVACStatusFlagsParseWithBuffer(context.Background(), io)
	case "ParameterValue":
		parameterType, _ := ParameterTypeByName(arguments[0])
		numBytes, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return ParameterValueParseWithBuffer[ParameterValue](context.Background(), io, parameterType, numBytes)
	case "ReplyOrConfirmation":
		var cBusOptions CBusOptions
		var requestContext RequestContext
		return ReplyOrConfirmationParseWithBuffer[ReplyOrConfirmation](context.Background(), io, cBusOptions, requestContext)
	case "CBusOptions":
		return CBusOptionsParseWithBuffer(context.Background(), io)
	case "TemperatureBroadcastData":
		return TemperatureBroadcastDataParseWithBuffer(context.Background(), io)
	case "PanicStatus":
		return PanicStatusParseWithBuffer(context.Background(), io)
	case "IdentifyReplyCommandUnitSummary":
		return IdentifyReplyCommandUnitSummaryParseWithBuffer(context.Background(), io)
	case "InterfaceOptions1PowerUpSettings":
		return InterfaceOptions1PowerUpSettingsParseWithBuffer(context.Background(), io)
	case "MonitoredSAL":
		var cBusOptions CBusOptions
		return MonitoredSALParseWithBuffer[MonitoredSAL](context.Background(), io, cBusOptions)
	case "ReplyNetwork":
		return ReplyNetworkParseWithBuffer(context.Background(), io)
	case "SerialNumber":
		return SerialNumberParseWithBuffer(context.Background(), io)
	case "CBusPointToMultiPointCommand":
		var cBusOptions CBusOptions
		return CBusPointToMultiPointCommandParseWithBuffer[CBusPointToMultiPointCommand](context.Background(), io, cBusOptions)
	case "StatusRequest":
		return StatusRequestParseWithBuffer[StatusRequest](context.Background(), io)
	case "InterfaceOptions3":
		return InterfaceOptions3ParseWithBuffer(context.Background(), io)
	case "InterfaceOptions1":
		return InterfaceOptions1ParseWithBuffer(context.Background(), io)
	case "InterfaceOptions2":
		return InterfaceOptions2ParseWithBuffer(context.Background(), io)
	case "HVACModeAndFlags":
		return HVACModeAndFlagsParseWithBuffer(context.Background(), io)
	case "LightingData":
		return LightingDataParseWithBuffer[LightingData](context.Background(), io)
	case "SALData":
		applicationId, _ := ApplicationIdByName(arguments[0])
		return SALDataParseWithBuffer[SALData](context.Background(), io, applicationId)
	case "CBusCommand":
		var cBusOptions CBusOptions
		return CBusCommandParseWithBuffer[CBusCommand](context.Background(), io, cBusOptions)
	case "HVACHumidity":
		return HVACHumidityParseWithBuffer(context.Background(), io)
	case "HVACHumidityModeAndFlags":
		return HVACHumidityModeAndFlagsParseWithBuffer(context.Background(), io)
	case "CBusConstants":
		return CBusConstantsParseWithBuffer(context.Background(), io)
	case "SerialInterfaceAddress":
		return SerialInterfaceAddressParseWithBuffer(context.Background(), io)
	case "MeasurementData":
		return MeasurementDataParseWithBuffer[MeasurementData](context.Background(), io)
	case "HVACZoneList":
		return HVACZoneListParseWithBuffer(context.Background(), io)
	case "MediaTransportControlData":
		return MediaTransportControlDataParseWithBuffer[MediaTransportControlData](context.Background(), io)
	case "StatusByte":
		return StatusByteParseWithBuffer(context.Background(), io)
	case "TriggerControlLabelOptions":
		return TriggerControlLabelOptionsParseWithBuffer(context.Background(), io)
	case "HVACAuxiliaryLevel":
		return HVACAuxiliaryLevelParseWithBuffer(context.Background(), io)
	case "ErrorReportingData":
		return ErrorReportingDataParseWithBuffer[ErrorReportingData](context.Background(), io)
	case "UnitAddress":
		return UnitAddressParseWithBuffer(context.Background(), io)
	case "SecurityArmCode":
		return SecurityArmCodeParseWithBuffer(context.Background(), io)
	case "MeteringData":
		return MeteringDataParseWithBuffer[MeteringData](context.Background(), io)
	case "EnableControlData":
		return EnableControlDataParseWithBuffer(context.Background(), io)
	case "ApplicationAddress2":
		return ApplicationAddress2ParseWithBuffer(context.Background(), io)
	case "ApplicationAddress1":
		return ApplicationAddress1ParseWithBuffer(context.Background(), io)
	case "RequestContext":
		return RequestContextParseWithBuffer(context.Background(), io)
	case "TriggerControlData":
		return TriggerControlDataParseWithBuffer[TriggerControlData](context.Background(), io)
	case "HVACStartTime":
		return HVACStartTimeParseWithBuffer(context.Background(), io)
	case "HVACTemperature":
		return HVACTemperatureParseWithBuffer(context.Background(), io)
	case "RequestTermination":
		return RequestTerminationParseWithBuffer(context.Background(), io)
	case "CBusMessage":
		isResponse, err := utils.StrToBool(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		var requestContext RequestContext
		var cBusOptions CBusOptions
		return CBusMessageParseWithBuffer[CBusMessage](context.Background(), io, isResponse, requestContext, cBusOptions)
	case "ErrorReportingSystemCategory":
		return ErrorReportingSystemCategoryParseWithBuffer(context.Background(), io)
	case "PowerUp":
		return PowerUpParseWithBuffer(context.Background(), io)
	case "Reply":
		var cBusOptions CBusOptions
		var requestContext RequestContext
		return ReplyParseWithBuffer[Reply](context.Background(), io, cBusOptions, requestContext)
	case "TelephonyData":
		return TelephonyDataParseWithBuffer[TelephonyData](context.Background(), io)
	case "HVACHumidityStatusFlags":
		return HVACHumidityStatusFlagsParseWithBuffer(context.Background(), io)
	case "ParameterChange":
		return ParameterChangeParseWithBuffer(context.Background(), io)
	case "ErrorReportingSystemCategoryType":
		errorReportingSystemCategoryClass, _ := ErrorReportingSystemCategoryClassByName(arguments[0])
		return ErrorReportingSystemCategoryTypeParseWithBuffer[ErrorReportingSystemCategoryType](context.Background(), io, errorReportingSystemCategoryClass)
	case "Confirmation":
		return ConfirmationParseWithBuffer(context.Background(), io)
	case "SecurityData":
		return SecurityDataParseWithBuffer[SecurityData](context.Background(), io)
	case "NetworkProtocolControlInformation":
		return NetworkProtocolControlInformationParseWithBuffer(context.Background(), io)
	case "CBusHeader":
		return CBusHeaderParseWithBuffer(context.Background(), io)
	case "Request":
		var cBusOptions CBusOptions
		return RequestParseWithBuffer[Request](context.Background(), io, cBusOptions)
	case "Alpha":
		return AlphaParseWithBuffer(context.Background(), io)
	case "CALData":
		var requestContext RequestContext
		return CALDataParseWithBuffer[CALData](context.Background(), io, requestContext)
	case "Checksum":
		return ChecksumParseWithBuffer(context.Background(), io)
	case "CALReply":
		var cBusOptions CBusOptions
		var requestContext RequestContext
		return CALReplyParseWithBuffer[CALReply](context.Background(), io, cBusOptions, requestContext)
	case "CustomManufacturer":
		numBytes, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return CustomManufacturerParseWithBuffer(context.Background(), io, numBytes)
	case "AccessControlData":
		return AccessControlDataParseWithBuffer[AccessControlData](context.Background(), io)
	case "ClockAndTimekeepingData":
		return ClockAndTimekeepingDataParseWithBuffer[ClockAndTimekeepingData](context.Background(), io)
	case "NetworkRoute":
		return NetworkRouteParseWithBuffer(context.Background(), io)
	case "ResponseTermination":
		return ResponseTerminationParseWithBuffer(context.Background(), io)
	case "LevelInformation":
		return LevelInformationParseWithBuffer[LevelInformation](context.Background(), io)
	case "TamperStatus":
		return TamperStatusParseWithBuffer(context.Background(), io)
	case "IdentifyReplyCommand":
		attribute, _ := AttributeByName(arguments[0])
		numBytes, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return IdentifyReplyCommandParseWithBuffer[IdentifyReplyCommand](context.Background(), io, attribute, numBytes)
	case "HVACRawLevels":
		return HVACRawLevelsParseWithBuffer(context.Background(), io)
	case "ZoneStatus":
		return ZoneStatusParseWithBuffer(context.Background(), io)
	case "BridgeAddress":
		return BridgeAddressParseWithBuffer(context.Background(), io)
	case "LightingLabelOptions":
		return LightingLabelOptionsParseWithBuffer(context.Background(), io)
	case "CustomTypes":
		numBytes, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return CustomTypesParseWithBuffer(context.Background(), io, numBytes)
	case "EncodedReply":
		var cBusOptions CBusOptions
		var requestContext RequestContext
		return EncodedReplyParseWithBuffer[EncodedReply](context.Background(), io, cBusOptions, requestContext)
	case "CBusPointToPointToMultiPointCommand":
		var cBusOptions CBusOptions
		return CBusPointToPointToMultiPointCommandParseWithBuffer[CBusPointToPointToMultiPointCommand](context.Background(), io, cBusOptions)
	case "CBusPointToPointCommand":
		var cBusOptions CBusOptions
		return CBusPointToPointCommandParseWithBuffer[CBusPointToPointCommand](context.Background(), io, cBusOptions)
	case "AirConditioningData":
		return AirConditioningDataParseWithBuffer[AirConditioningData](context.Background(), io)
	case "LogicAssignment":
		return LogicAssignmentParseWithBuffer(context.Background(), io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
