/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"encoding/binary"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/codegen"
	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BVLCDistributeBroadcastToNetwork is the corresponding interface of BVLCDistributeBroadcastToNetwork
type BVLCDistributeBroadcastToNetwork interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BVLC
	// GetNpdu returns Npdu (property field)
	GetNpdu() NPDU
	// IsBVLCDistributeBroadcastToNetwork is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBVLCDistributeBroadcastToNetwork()
	// CreateBuilder creates a BVLCDistributeBroadcastToNetworkBuilder
	CreateBVLCDistributeBroadcastToNetworkBuilder() BVLCDistributeBroadcastToNetworkBuilder
}

// _BVLCDistributeBroadcastToNetwork is the data-structure of this message
type _BVLCDistributeBroadcastToNetwork struct {
	BVLCContract
	Npdu NPDU

	// Arguments.
	BvlcPayloadLength uint16
}

var _ BVLCDistributeBroadcastToNetwork = (*_BVLCDistributeBroadcastToNetwork)(nil)
var _ BVLCRequirements = (*_BVLCDistributeBroadcastToNetwork)(nil)

// NewBVLCDistributeBroadcastToNetwork factory function for _BVLCDistributeBroadcastToNetwork
func NewBVLCDistributeBroadcastToNetwork(npdu NPDU, bvlcPayloadLength uint16) *_BVLCDistributeBroadcastToNetwork {
	if npdu == nil {
		panic("npdu of type NPDU for BVLCDistributeBroadcastToNetwork must not be nil")
	}
	_result := &_BVLCDistributeBroadcastToNetwork{
		BVLCContract: NewBVLC(),
		Npdu:         npdu,
	}
	_result.BVLCContract.(*_BVLC)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BVLCDistributeBroadcastToNetworkBuilder is a builder for BVLCDistributeBroadcastToNetwork
type BVLCDistributeBroadcastToNetworkBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(npdu NPDU) BVLCDistributeBroadcastToNetworkBuilder
	// WithNpdu adds Npdu (property field)
	WithNpdu(NPDU) BVLCDistributeBroadcastToNetworkBuilder
	// WithNpduBuilder adds Npdu (property field) which is build by the builder
	WithNpduBuilder(func(NPDUBuilder) NPDUBuilder) BVLCDistributeBroadcastToNetworkBuilder
	// WithArgBvlcPayloadLength sets a parser argument
	WithArgBvlcPayloadLength(uint16) BVLCDistributeBroadcastToNetworkBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BVLCBuilder
	// Build builds the BVLCDistributeBroadcastToNetwork or returns an error if something is wrong
	Build() (BVLCDistributeBroadcastToNetwork, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BVLCDistributeBroadcastToNetwork
}

// NewBVLCDistributeBroadcastToNetworkBuilder() creates a BVLCDistributeBroadcastToNetworkBuilder
func NewBVLCDistributeBroadcastToNetworkBuilder() BVLCDistributeBroadcastToNetworkBuilder {
	return &_BVLCDistributeBroadcastToNetworkBuilder{_BVLCDistributeBroadcastToNetwork: new(_BVLCDistributeBroadcastToNetwork)}
}

type _BVLCDistributeBroadcastToNetworkBuilder struct {
	*_BVLCDistributeBroadcastToNetwork

	parentBuilder *_BVLCBuilder

	collectedErr []error
}

var _ (BVLCDistributeBroadcastToNetworkBuilder) = (*_BVLCDistributeBroadcastToNetworkBuilder)(nil)

func (b *_BVLCDistributeBroadcastToNetworkBuilder) setParent(contract BVLCContract) {
	b.BVLCContract = contract
	contract.(*_BVLC)._SubType = b._BVLCDistributeBroadcastToNetwork
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) WithMandatoryFields(npdu NPDU) BVLCDistributeBroadcastToNetworkBuilder {
	return b.WithNpdu(npdu)
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) WithNpdu(npdu NPDU) BVLCDistributeBroadcastToNetworkBuilder {
	b.Npdu = npdu
	return b
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) WithNpduBuilder(builderSupplier func(NPDUBuilder) NPDUBuilder) BVLCDistributeBroadcastToNetworkBuilder {
	builder := builderSupplier(b.Npdu.CreateNPDUBuilder())
	var err error
	b.Npdu, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "NPDUBuilder failed"))
	}
	return b
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) WithArgBvlcPayloadLength(bvlcPayloadLength uint16) BVLCDistributeBroadcastToNetworkBuilder {
	b.BvlcPayloadLength = bvlcPayloadLength
	return b
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) Build() (BVLCDistributeBroadcastToNetwork, error) {
	if b.Npdu == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'npdu' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BVLCDistributeBroadcastToNetwork.deepCopy(), nil
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) MustBuild() BVLCDistributeBroadcastToNetwork {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) Done() BVLCBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBVLCBuilder().(*_BVLCBuilder)
	}
	return b.parentBuilder
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) buildForBVLC() (BVLC, error) {
	return b.Build()
}

func (b *_BVLCDistributeBroadcastToNetworkBuilder) DeepCopy() any {
	_copy := b.CreateBVLCDistributeBroadcastToNetworkBuilder().(*_BVLCDistributeBroadcastToNetworkBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBVLCDistributeBroadcastToNetworkBuilder creates a BVLCDistributeBroadcastToNetworkBuilder
func (b *_BVLCDistributeBroadcastToNetwork) CreateBVLCDistributeBroadcastToNetworkBuilder() BVLCDistributeBroadcastToNetworkBuilder {
	if b == nil {
		return NewBVLCDistributeBroadcastToNetworkBuilder()
	}
	return &_BVLCDistributeBroadcastToNetworkBuilder{_BVLCDistributeBroadcastToNetwork: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BVLCDistributeBroadcastToNetwork) GetBvlcFunction() uint8 {
	return 0x09
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BVLCDistributeBroadcastToNetwork) GetParent() BVLCContract {
	return m.BVLCContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BVLCDistributeBroadcastToNetwork) GetNpdu() NPDU {
	return m.Npdu
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBVLCDistributeBroadcastToNetwork(structType any) BVLCDistributeBroadcastToNetwork {
	if casted, ok := structType.(BVLCDistributeBroadcastToNetwork); ok {
		return casted
	}
	if casted, ok := structType.(*BVLCDistributeBroadcastToNetwork); ok {
		return *casted
	}
	return nil
}

func (m *_BVLCDistributeBroadcastToNetwork) GetTypeName() string {
	return "BVLCDistributeBroadcastToNetwork"
}

func (m *_BVLCDistributeBroadcastToNetwork) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BVLCContract.(*_BVLC).getLengthInBits(ctx))

	// Simple field (npdu)
	lengthInBits += m.Npdu.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BVLCDistributeBroadcastToNetwork) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BVLCDistributeBroadcastToNetwork) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BVLC, bvlcPayloadLength uint16) (__bVLCDistributeBroadcastToNetwork BVLCDistributeBroadcastToNetwork, err error) {
	m.BVLCContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BVLCDistributeBroadcastToNetwork"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BVLCDistributeBroadcastToNetwork")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	npdu, err := ReadSimpleField[NPDU](ctx, "npdu", ReadComplex[NPDU](NPDUParseWithBufferProducer((uint16)(bvlcPayloadLength)), readBuffer), codegen.WithByteOrder(binary.BigEndian))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'npdu' field"))
	}
	m.Npdu = npdu

	if closeErr := readBuffer.CloseContext("BVLCDistributeBroadcastToNetwork"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BVLCDistributeBroadcastToNetwork")
	}

	return m, nil
}

func (m *_BVLCDistributeBroadcastToNetwork) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))), utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BVLCDistributeBroadcastToNetwork) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BVLCDistributeBroadcastToNetwork"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BVLCDistributeBroadcastToNetwork")
		}

		if err := WriteSimpleField[NPDU](ctx, "npdu", m.GetNpdu(), WriteComplex[NPDU](writeBuffer), codegen.WithByteOrder(binary.BigEndian)); err != nil {
			return errors.Wrap(err, "Error serializing 'npdu' field")
		}

		if popErr := writeBuffer.PopContext("BVLCDistributeBroadcastToNetwork"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BVLCDistributeBroadcastToNetwork")
		}
		return nil
	}
	return m.BVLCContract.(*_BVLC).serializeParent(ctx, writeBuffer, m, ser)
}

////
// Arguments Getter

func (m *_BVLCDistributeBroadcastToNetwork) GetBvlcPayloadLength() uint16 {
	return m.BvlcPayloadLength
}

//
////

func (m *_BVLCDistributeBroadcastToNetwork) IsBVLCDistributeBroadcastToNetwork() {}

func (m *_BVLCDistributeBroadcastToNetwork) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BVLCDistributeBroadcastToNetwork) deepCopy() *_BVLCDistributeBroadcastToNetwork {
	if m == nil {
		return nil
	}
	_BVLCDistributeBroadcastToNetworkCopy := &_BVLCDistributeBroadcastToNetwork{
		m.BVLCContract.(*_BVLC).deepCopy(),
		utils.DeepCopy[NPDU](m.Npdu),
		m.BvlcPayloadLength,
	}
	_BVLCDistributeBroadcastToNetworkCopy.BVLCContract.(*_BVLC)._SubType = m
	return _BVLCDistributeBroadcastToNetworkCopy
}

func (m *_BVLCDistributeBroadcastToNetwork) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
